% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClusterAlgoPredict.R
\name{clusterAlgoPredict}
\alias{clusterAlgoPredict}
\title{Create an instance of the [\code{\linkS4class{ClusterAlgoPredict}}] class}
\usage{
clusterAlgoPredict(
  algo = "EM",
  nbIterBurn = 50,
  nbIterLong = 100,
  epsilon = 1e-07
)
}
\arguments{
\item{algo}{character string with the second stage estimation algorithm.
Possible values are "EM", "SemiSEM". Default value is "EM".}

\item{nbIterBurn}{Integer defining the maximal number of burning iterations.
Default value is 50.}

\item{nbIterLong}{Integer defining the maximal number of iterations.
Default value is 100.}

\item{epsilon}{Real defining the epsilon value for the algorithm. Not used
with "semiSEM" algorithms. Default value is 1.e-7.}
}
\value{
a [\code{\linkS4class{ClusterAlgoPredict}}] object
}
\description{
A prediction algorithm is a two stage algorithm. In the first stage we perform
a Monte Carlo algorithm for simulating both missing values and latent class
variables. In the second stage, we simulate or impute missing values.
}
\details{
The epsilon value is not used when the algorithm is "SemiSEM".
}
\examples{
clusterAlgoPredict()
clusterAlgoPredict(algo="SemiSEM", nbIterBurn=0)
clusterAlgoPredict(algo="EM", epsilon = 1e-06)

}
\author{
Serge Iovleff
}
