% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_mix_win.R
\name{build_mix_win}
\alias{build_mix_win}
\title{Build the window to read-in mixture data.}
\usage{
build_mix_win()
}
\description{
This function is run when a user clicks the "Load mixture data" button in the
main MixSIAR GUI, and creates a separate GUI window (\code{mix_win}) where
the user loads the mixture data file. \code{build_mix_win} calls
\code{\link{load_mix_data}} when the user clicks the "I'm finished" button.
}
\details{
The "Load mix data" window contains:
\enumerate{
  \item "Load consumer data file" gbutton which loads the .csv file into \code{X},
  \item gtables where the user selects which columns of \code{X} are Isotopes
        and Fixed/Random/Continuous Effects.
  \item (formerly) Individual Effect gcheckbox ("Include 'Individual' as a Random Effect"),
  \item "I'm finished" gbutton that closes \code{mix_win} and calls
        \code{\link{load_mix_data}}.
}

If more than 2 Fixed/Random Effects are selected, a separate WARNING gwindow
prompts the user to select 2, 1, or 0.

If more than 1 Continuous Effect is selected, a separate WARNING gwindow
prompts the user to select 1 or 0.

If 2 Fixed/Random Effects are selected, a separate gwindow asks the user if
the effects are hierarchical/nested.

Finally, the function adds a green check image if the data is successfully
loaded, or a red_x image if not.
}
\seealso{
\code{\link{load_mix_data}}, which is run when the "Load MIX data"
         window is closed by clicking the "I'm finished" button.
}

