% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_mix_data.R
\name{load_mix_data}
\alias{load_mix_data}
\title{Load mixture data}
\usage{
load_mix_data(filename, iso_names, factors, fac_random, fac_nested,
  cont_effects)
}
\arguments{
\item{filename}{csv file with the mixture/consumer data}

\item{iso_names}{vector of isotope column headings in 'filename'}

\item{factors}{vector of random/fixed effect column headings in 'filename'.
NULL if no factors.}

\item{fac_random}{vector of TRUE/FALSE, TRUE if factor is random effect, FALSE
if fixed effect. NULL if no factors.}

\item{fac_nested}{vector of TRUE/FALSE, TRUE if factor is nested within the
other. Only applies if 2 factors. NULL otherwise.}

\item{cont_effects}{vector of continuous effect column headings in 'filename'}
}
\value{
\code{mix}, a list including:
\itemize{
 \item \code{mix$data}: dataframe, raw mix/consumer data (all columns in 'filename'),
 \item \code{mix$data_iso}: matrix, mix/consumer biotracer/isotope values (those
       specified in 'iso_names'),
 \item \code{mix$n.iso}: integer, number of biotracers/isotopes,
 \item \code{mix$n.re}: integer, number of random effects,
 \item \code{mix$n.ce}: integer, number of continuous effects,
 \item \code{mix$FAC}: list of fixed/random effect values, each of which contains:
   \itemize{
     \item \code{values}: factor, values of the effect for each mix/consumer point
     \item \code{levels}: numeric vector, total number of values
     \item \code{labels}: character vector, names for each factor level
     \item \code{lookup}: numeric vector, if 2 factors and Factor.2 is nested
     within Factor.1, stores Factor.1 values for each level of Factor.2 (e.g.
     Wolf Ex has 8 Packs in 3 Regions, and \code{mix$FAC[[2]]$lookup =
     c(1,1,1,2,2,2,2,3)}, the Regions each Pack belongs to).
     \item \code{re}: T/F, is the factor a Random Effect? (FALSE = Fixed Effect)
     \item \code{name}: character, name of the factor (e.g. "Region")
   }
 \item \code{mix$CE}: list of length \code{n.ce}, contains the \code{cont_effects}
  values centered (subtract the mean) and scaled (divide by SD)
 \item \code{mix$CE_orig}: list of length \code{n.ce}, contains the original
  (unscaled) \code{cont_effects} values
 \item \code{mix$CE_center}: vector of length \code{n.ce}, means of each \code{cont_effects}
 \item \code{mix$CE_scale}: vector of length \code{n.ce}, SD of each \code{cont_effects}
 \item \code{mix$cont_effects}: vector of length \code{n.ce}, names of each \code{cont_effects}
 \item \code{mix$MU_names}: vector of biotracer/iso MEAN column headings to look for
 in the source and discrimination files (e.g. 'd13C' in \code{iso_names},
 'Meand13C' here)
 \item \code{mix$SIG_names}: vector of biotracer/iso SD column headings to look for
 in the source and discrimination files (e.g. 'd13C' in \code{iso_names},
 'SDd13C' here)
 \item \code{mix$iso_names}: vector of isotope column headings in 'filename' (same
 as input)
 \item \code{mix$N}: integer, number of mix/consumer data points
 \item \code{mix$n.fe}: integer, number of Fixed Effects
 \item \code{mix$n.effects}: integer, number of Fixed Effects + Random Effects
 \item \code{mix$factors}: vector of length \code{n.effects}, names of the
 Fixed and Random Effects
 \item \code{mix$fac_random}: T/F vector of length \code{n.effects} indicating
 which effects are Random (= TRUE) and Fixed (= FALSE)
 \item \code{mix$fac_nested}: T/F vector of length \code{n.effects} indicating
 which effects are nested within the other, if any
 \item \code{mix$fere}: TRUE if there are 2 Fixed Effects or 1 Fixed Effect and
 1 Random Effect, FALSE otherwise. Used by \code{write_JAGS_model}.
}

If no biotracer/isotope columns are specified, a WARNING prompts the user to
 select 2, 1, or 0.

If more than 2 Fixed/Random Effects are selected, a WARNING prompts the user
to select 2, 1, or 0.

If more than 1 Continuous Effect is selected, a WARNING prompts the user to
select 1 or 0.
}
\description{
\code{load_mix_data} loads the mixture data file and names the biotracers and
any Fixed, Random, or Continuous Effects.
}
