% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smnr.R
\name{mixbspline}
\alias{mixbspline}
\title{Mixture of Nonparametric Regressions Using B-spline}
\usage{
mixbspline(u, x, y, ini = NULL, k = NULL, mm = NULL, tt = NULL, a = NULL)
}
\arguments{
\item{u}{vector of grid points.}

\item{x}{the predictors we observed; needs to be standardized;}

\item{y}{the observation we observed}

\item{ini}{initial values of proportion. If left as NULL will be calculated from mixture of the linear regression
with normal error assumption.}

\item{k}{number of component, the default value is 2;}

\item{mm}{order of spline, default is cubic spline with mm=4;}

\item{tt}{the knots; default is quantile(x,seq(0.05,0.95,0.2))}

\item{a}{the interval that contains x; default is c(mean(x)-2\emph{sqrt(var(x)),mean(x)+2}sqrt(var(x)));}
}
\value{
mu_u:estimated mean functions with interpolate;est_mu: estimated mean functions,est_p: estimated proportion;est_var: estimated variance
}
\description{
This function is used to fit mixture of nonparametric regressions using b-spline
assuming the error is normal and the variance of the errors are equal
}
