% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TestIndCopula.R
\name{TestIndCopula}
\alias{TestIndCopula}
\title{Statistics and P-values for a test of independence between random variables}
\usage{
TestIndCopula(
  x,
  trunc.level = 2,
  B = 1000,
  par = FALSE,
  ncores = 2,
  graph = FALSE
)
}
\arguments{
\item{x}{Data matrix}

\item{trunc.level}{Only subsets of cardinality <= trunc.level (default=2) are considered for the Moebius statistics.}

\item{B}{Number of multipliers samples (default = 1000)}

\item{par}{Set to TRUE if one prefers paraller computing (slower)}

\item{ncores}{Number of cores for parallel computing (default is 2)}

\item{graph}{Set to TRUE if one wants the dependogram of P-values for the Moebius statistics}
}
\value{
\item{stat}{List of Cramer-von Mises statistics cvm, Sn  from the multilinear copula, and test combinations Tn and Tn2 (only pairs)}

\item{pvalue}{Approximated P-values for the tests using Gaussian multipliers}

\item{card}{Cardinaly of the subsets for the Moebius statistics}

\item{subsets}{Subsets for the Moebius statistics}
}
\description{
This function computes Cramer-von Mises statistics and their combination for a tests of independence between random variables with arbitrary distributions. The P-values are computed using Gaussian multipliers.
}
\examples{
x <- matrix(rnorm(250),ncol=5)
out <-TestIndCopula(x)
}
\references{
Genest, Neslehova, Remillard & Murphy (2019). Testing for independence in arbitrary distributions
}
