% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rf_opt.R
\name{rf_opt}
\alias{rf_opt}
\title{Bayesian Optimization for Random Forest}
\usage{
rf_opt(train_data, train_label, test_data, test_label, num_tree = 500L,
  mtry_range = c(1L, ncol(train_data) - 1), min_node_size_range = c(1L,
  as.integer(sqrt(nrow(train_data)))), init_points = 4, n_iter = 10,
  acq = "ei", kappa = 2.576, eps = 0, optkernel = list(type =
  "exponential", power = 2))
}
\arguments{
\item{train_data}{A data frame for training of Random Forest}

\item{train_label}{The column of class to classify in the training data}

\item{test_data}{A data frame for training of xgboost}

\item{test_label}{The column of class to classify in the test data}

\item{num_tree}{The range of the number of trees for forest. Defaults
to 500 (no optimization).}

\item{mtry_range}{Value of mtry used. Defaults from 1 to number of features.}

\item{min_node_size_range}{The range of minimum node sizes to best tested.
Default min is 1 and max is sqrt(nrow(train_data)).}

\item{init_points}{Number of randomly chosen points to sample the
target function before Bayesian Optimization fitting the Gaussian Process.}

\item{n_iter}{Total number of times the Bayesian Optimization is to repeated.}

\item{acq}{Acquisition function type to be used. Can be "ucb", "ei" or "poi".
\itemize{
  \item \code{ucb} GP Upper Confidence Bound
  \item \code{ei} Expected Improvement
  \item \code{poi} Probability of Improvement
}}

\item{kappa}{tunable parameter kappa of GP Upper Confidence Bound, to balance exploitation against exploration,
increasing kappa will make the optimized hyperparameters pursuing exploration.}

\item{eps}{tunable parameter epsilon of Expected Improvement and Probability of Improvement, to balance exploitation against exploration,
increasing epsilon will make the optimized hyperparameters are more spread out across the whole range.}

\item{optkernel}{Kernel (aka correlation function) for the underlying Gaussian Process. This parameter should be a list
that specifies the type of correlation function along with the smoothness parameter. Popular choices are square exponential (default) or matern 5/2}
}
\value{
The test accuracy and a list of Bayesian Optimization result is returned:
\itemize{
  \item \code{Best_Par} a named vector of the best hyperparameter set found
  \item \code{Best_Value} the value of metrics achieved by the best hyperparameter set
  \item \code{History} a \code{data.table} of the bayesian optimization history
  \item \code{Pred} a \code{data.table} with validation/cross-validation prediction for each round of bayesian optimization history
}
}
\description{
This function estimates parameters for Random Forest based on bayesian optimization.
}
\examples{
library(MlBayesOpt)

set.seed(71)
res0 <- rf_opt(train_data = iris_train,
               train_label = Species,
               test_data = iris_test,
               test_label = Species,
               mtry_range = c(1L, ncol(iris_train) - 1),
               num_tree = 10L,
               init_points = 10,
               n_iter = 1)

}
