% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.pheno.off.R
\name{get.pheno.off}
\alias{get.pheno.off}
\title{Export underlying offspring phenotypes}
\usage{
get.pheno.off(
  population,
  database = NULL,
  gen = NULL,
  cohorts = NULL,
  use.id = FALSE
)
}
\arguments{
\item{population}{Population list}

\item{database}{Groups of individuals to consider for the export}

\item{gen}{Quick-insert for database (vector of all generations to export)}

\item{cohorts}{Quick-insert for database (vector of names of cohorts to export)}

\item{use.id}{Set to TRUE to use MoBPS ids instead of Sex_Nr_Gen based names (default: FALSE)}
}
\value{
Avg. phenotype of the offspring of in gen/database/cohorts selected individuals
}
\description{
Function to export offspring phenotypes
}
\examples{
data(ex_pop)
get.pheno.off(ex_pop, gen=2)
}
