% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{noise_vol}
\alias{noise_vol}
\title{Approximate Hypervolume Estimate}
\usage{
noise_vol(data, method = c("hypvol", "convexhull", "ellipsoidhull"),
  reciprocal = FALSE)
}
\arguments{
\item{data}{A numeric vector, matrix, or data frame of observations. Categorical variables are not allowed. If a matrix or data frame, rows correspond to observations and columns correspond to variables.}

\item{method}{The method used to estimate the hypervolume. The "\code{convexhull}" and "\code{ellipsoidhull}" options require loading the \code{geometry} and \code{cluster} libraries, respectively.}

\item{reciprocal}{A logical variable indicating whether or not the reciprocal hypervolume is desired rather than the hypervolume itself. The default is to return the hypervolume.}
}
\value{
A hypervolume estimate (or its inverse), to be used as the hypervolume parameter for the noise component when observations are designated as noise in \code{\link{MoE_clust}}.
}
\description{
Computes simple appproximations to the hypervolume of univariate and multivariate data sets.
}
\examples{
data(ais)
noise_vol(ais[,3:7], reciprocal=TRUE)
}
\seealso{
\code{\link[mclust]{hypvol}}, \code{\link[geometry]{convhulln}}, \code{\link[cluster]{ellipsoidhull}}
}
\author{
Keefe Murphy - \href{keefe.murphy@ucd.ie}{<keefe.murphy@ucd.ie>}
}
