% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3b_wrapperFunctions.R
\name{monanDataCreate}
\alias{monanDataCreate}
\title{monanDataCreate}
\usage{
monanDataCreate(...)
}
\arguments{
\item{...}{The monan objects to be included in the process State.
This must include exactly one edgelist (dependent variable) and the
two nodesets associated with the edgelist.
Further allowed elements are (monadic or dyadic) covariates of locations and people}
}
\value{
An object of class "processState.monan".
}
\description{
A function to create a moman process state, i.e.,
a MoNAn object that stores all information
about the data that will be used in the estimation. This includes the
outcome variable (edgelist), the nodesets, and all covariates.
}
\examples{
#' # create objects (which are later combined to the process state)
transfers <- createEdgelist(mobilityEdgelist,
  nodeSet = c("organisations", "organisations", "people")
)
people <- createNodeSet(1:nrow(mobilityEdgelist))
organisations <- createNodeSet(1:length(orgRegion))
sameRegion <- outer(orgRegion, orgRegion, "==") * 1
sameRegion <- createNetwork(sameRegion,
  nodeSet = c("organisations", "organisations")
)
region <- createNodeVariable(orgRegion, nodeSet = "organisations")
size <- createNodeVariable(orgSize, nodeSet = "organisations", addSim = TRUE)
sex <- createNodeVariable(indSex, nodeSet = "people")

monanDataCreate(transfers, people, organisations, 
                sameRegion, region, size, sex)
}
