% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/joint.R
\name{coef.jointmotbf}
\alias{coef.jointmotbf}
\title{Extract Coefficients  of a \code{"jointmotbf"} Object}
\usage{
\method{coef}{jointmotbf}(object, ...)
}
\arguments{
\item{object}{An MoTBF function.}

\item{\dots}{Other arguments, unnecessary for this function.}
}
\value{
A \code{"numeric"} vector with the parameters of the function.
}
\description{
Extracts the parameters of the learned multivariate mixtures of truncated basis
functions.
}
\examples{
require(mnormt) ## Load the package to generate a multinormal dataset
## Dataset
Mean <- 0; nVar <- 2; ro <- 0
varcov <- matrix(c(rep(c(1, rep(ro, nVar)), nVar-1),1), nrow=nVar)
means <- rep(Mean, nVar)
X <- rmnorm(100,means,varcov)
data <- standardizeDataset(data.frame(X))

## Joint function
dim <-c(2,4)
param <- parametersJointMoTBF(data, dimensions = dim)
P <- jointMoTBF(param)
P$Time

## Coefficients
coef(P)

#############################################################################
## MORE EXAMPLES ############################################################
#############################################################################
## ## Dataset
## Mean <- 0; nVar <- 3; ro <- 0
## varcov <- matrix(c(rep(c(1, rep(ro, nVar)), nVar-1),1), nrow=nVar)
## means <- rep(Mean, nVar)
## X <- rmnorm(100,means,varcov)
## data <- standardizeDataset(data.frame(X))
##
## ## Joint function
## dim <-c(2,4,3)
## param <- parametersJointMoTBF(data, dimensions = dim)
## P <- jointMoTBF(param)
## P$Time
##
## ## Coefficients
## coef(P)
##############################################################################
##############################################################################
}
\seealso{
\link{parametersJointMoTBF} and \link{jointMoTBF}
}

