% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/joint.R
\name{plot.jointmotbf}
\alias{plot.jointmotbf}
\title{Bidimensional Plots for \code{'jointmotbf'} Objects}
\usage{
\method{plot}{jointmotbf}(x, type = "contour", ranges = NULL,
  orientation = c(5, -30), data = NULL, filled = TRUE,
  ticktype = "simple", ...)
}
\arguments{
\item{x}{An object of class \code{'jointmotbf'}.}

\item{type}{A \code{"character"} string: by default it is \code{"contour"}, the alternative one is \code{"perspective"}.}

\item{ranges}{A \code{"numeric"} matrix containing the domain of the variables by columns.}

\item{orientation}{A \code{"numeric"} vector indicating the perpective of the plot in degrees.
By default it is \code{(5,-30)}.}

\item{data}{A dataset of class \code{"data.frame"}. Only two columns are allowed, it means two variables.
It is only necessary to draw the points over the main plot. By defailt it is \code{NULL}.}

\item{filled}{A logical argument; it is only used if \code{type = "contour"}
is active; by default is \code{TRUE}  so filled contours are plotted.}

\item{ticktype}{A \code{"character"} string: by default it is \code{"simple"} which draws just an arrow parallel to the axis
to indicate direction of increase; \code{"detailed"} draws normal ticks.}

\item{\dots}{Further arguments to be passed as for \link{plot}.}
}
\value{
A plot of the joint function.
}
\description{
Draws the perpective and the contour plots for joint functions.
}
\examples{
## 1 .EXAMPLE
## Dataset
X <- data.frame(rnorm(500), rnorm(500))

## Joint function
dim <- c(3,3) ## dim <- c(5,5)
param1 <- parametersJointMoTBF(X, dimensions = dim)
P <- jointMoTBF(param1)
P

## Plots
plot(P)
plot(P, type = "perspective", orientation = c(90,0))

#############################################################################
## MORE EXAMPLES ############################################################
#############################################################################
## ## Dataset
## X <- data.frame(rnorm(200,2), rexp(200, 1))
##
## ## Joint function
## dim <- c(4,5)
## param2 <- parametersJointMoTBF(X, dimensions = dim)
## P <- jointMoTBF(param2)
## P
##
## ## Plots
## plot(P)
## plot(P, filled = FALSE, data = X)
## plot(P, type = "perspective", orientation = c(10,180))
#############################################################################
#############################################################################
}
\seealso{
\link{jointMoTBF}
}

