% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conditional.R
\name{plotConditional}
\alias{plotConditional}
\title{Plots for Conditional Functions}
\usage{
plotConditional(conditionalFunction, data, nameChild = NULL,
  points = FALSE, color = NULL)
}
\arguments{
\item{conditionalFunction}{the output of the conditionalMethod. A list with the the interval of the parent
and the final MoTBF density function.}

\item{data}{The dataset used.}

\item{nameChild}{Name of the child variable in the conditional function. By default is \code{NULL}.}

\item{points}{Logical value. If \code{TRUE} the points of the data are overplotted.}

\item{color}{By default \code{NULL}, a selection of colors of the color palette of \R is used.}
}
\value{
A plot of the conditional function.
}
\description{
Get the graphical result of an MoTBF conditional function of two variables, i.e. a parent and his child.
}
\details{
If the number of parents is bigger than one, then the message 
"It is not possible plotting the conditional function." is shown.
}
\examples{
## Data
X <- rnorm(1000)
Y <- rnorm(1000, mean=X)
data <- data.frame(X=X,Y=Y)
cov(data)

## Conditional Learning
parent <- "X"
child <- "Y"
intervals <- 5
potential <- "MTE"
P <- conditionalMethod(data, nameParents=parent, nameChild=child, 
numIntervals=intervals, POTENTIAL_TYPE=potential)
plotConditional(conditionalFunction=P, data=data)
plotConditional(conditionalFunction=P, data=data, points=TRUE)

}
\seealso{
\link{conditionalMethod}
}
