% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Inference.R
\name{is.observed}
\alias{is.observed}
\title{Observed Node}
\usage{
is.observed(node, evi)
}
\arguments{
\item{node}{A \code{character} string, matching the node's name.}

\item{evi}{A \code{data.frame} of the evidence set.}
}
\value{
This function returns TRUE if "node" is included in "evi", or, otherwise, FALSE.
}
\description{
\code{is.observed()} checks whether a node belongs to the evidence set or not.
}
\examples{

## Data frame of the evidence set
  obs <- data.frame(lip = "1", alm2 = 0.5, stringsAsFactors=FALSE)
  
## Check if x is in obs
  is.observed("x", obs)
}
