% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coo-shapedescriptors.R
\name{coo_scalars}
\alias{coo_scalars}
\title{Calculates all scalar descriptors of shape}
\usage{
coo_scalars(coo, rectilinearity = FALSE)
}
\arguments{
\item{coo}{a \code{matrix} of (x; y) coordinates or any \code{Coo}}

\item{rectilinearity}{\code{logical} whether to include rectilinearity using \link{coo_rectilinearity}}
}
\value{
\code{data_frame}
}
\description{
See examples for the full list.
}
\details{
\link{coo_rectilinearity} being not particularly optimized, it takes around 30 times more
time to include it than to calculate \emph{all} others and is thus not includedby default.
by default.
}
\examples{

df <- bot \%>\% coo_scalars() # pass bot \%>\% coo_scalars(TRUE) if you want rectilinearity
colnames(df) \%>\% cat(sep="\n") # all scalars used

# a PCA on all these descriptors
TraCoe(coo_scalars(bot), fac=bot$fac) \%>\% PCA \%>\% plot_PCA(~type)

}
\seealso{
Other coo_ descriptors: 
\code{\link{coo_angle_edges}()},
\code{\link{coo_angle_tangent}()},
\code{\link{coo_area}()},
\code{\link{coo_boundingbox}()},
\code{\link{coo_chull}()},
\code{\link{coo_circularity}()},
\code{\link{coo_convexity}()},
\code{\link{coo_eccentricity}},
\code{\link{coo_elongation}()},
\code{\link{coo_length}()},
\code{\link{coo_lw}()},
\code{\link{coo_rectangularity}()},
\code{\link{coo_rectilinearity}()},
\code{\link{coo_solidity}()},
\code{\link{coo_tac}()},
\code{\link{coo_width}()}
}
\concept{coo_ descriptors}
