% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coo-utilities.R
\name{coo_template}
\alias{coo_template}
\alias{coo_template.default}
\alias{coo_template.list}
\alias{coo_template.Coo}
\alias{coo_template_relatively}
\alias{coo_template_relatively.list}
\alias{coo_template_relatively.Coo}
\title{'Templates' shapes}
\usage{
coo_template(coo, size)

\method{coo_template}{default}(coo, size = 1)

\method{coo_template}{list}(coo, size = 1)

\method{coo_template}{Coo}(coo, size = 1)

coo_template_relatively(coo, size = 1)

\method{coo_template_relatively}{list}(coo, size = 1)

\method{coo_template_relatively}{Coo}(coo, size = 1)
}
\arguments{
\item{coo}{A \code{list} or a \code{matrix} of coordinates.}

\item{size}{\code{numeric}. Indicates the length of the side 'inscribing'
the shape.}
}
\value{
Returns a matrix of \code{(x; y)}coordinates.
}
\description{
\code{coo_template} returns shape centered on the origin
and inscribed in a \code{size}-side square. \code{coo_template_relatively}
does the same but the biggest shape (as \code{prod(coo_diffrange)}) will
be of \code{size=size} and consequently not defined on single shapes.
}
\details{
See \link{coo_listpanel} for an illustration of this function. The morphospaces
functions also take profit of this function. May be useful to develop other graphical functions.
}
\examples{

coo <- bot[1]
coo_plot(coo_template(coo), xlim=c(-1, 1), ylim=c(-1, 1))
rect(-0.5, -0.5, 0.5, 0.5)

s <- 0.01
coo_plot(coo_template(coo, s))
rect(-s/2, -s/2, s/2, s/2)
}
\seealso{
Other coo_ utilities: 
\code{\link{coo_aligncalliper}()},
\code{\link{coo_alignminradius}()},
\code{\link{coo_alignxax}()},
\code{\link{coo_align}()},
\code{\link{coo_baseline}()},
\code{\link{coo_bookstein}()},
\code{\link{coo_boundingbox}()},
\code{\link{coo_calliper}()},
\code{\link{coo_centdist}()},
\code{\link{coo_center}()},
\code{\link{coo_centpos}()},
\code{\link{coo_close}()},
\code{\link{coo_down}()},
\code{\link{coo_dxy}()},
\code{\link{coo_extract}()},
\code{\link{coo_flipx}()},
\code{\link{coo_force2close}()},
\code{\link{coo_interpolate}()},
\code{\link{coo_is_closed}()},
\code{\link{coo_jitter}()},
\code{\link{coo_left}()},
\code{\link{coo_likely_clockwise}()},
\code{\link{coo_nb}()},
\code{\link{coo_perim}()},
\code{\link{coo_range}()},
\code{\link{coo_rev}()},
\code{\link{coo_right}()},
\code{\link{coo_rotatecenter}()},
\code{\link{coo_rotate}()},
\code{\link{coo_sample_prop}()},
\code{\link{coo_samplerr}()},
\code{\link{coo_sample}()},
\code{\link{coo_scale}()},
\code{\link{coo_shearx}()},
\code{\link{coo_slice}()},
\code{\link{coo_slidedirection}()},
\code{\link{coo_slidegap}()},
\code{\link{coo_slide}()},
\code{\link{coo_smoothcurve}()},
\code{\link{coo_smooth}()},
\code{\link{coo_trans}()},
\code{\link{coo_trimbottom}()},
\code{\link{coo_trimtop}()},
\code{\link{coo_trim}()},
\code{\link{coo_untiltx}()},
\code{\link{coo_up}()},
\code{\link{is_equallyspacedradii}()}

Other scaling functions: 
\code{\link{coo_scale}()}
}
\concept{coo_ utilities}
\concept{scaling functions}
