% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_Normal.R
\name{sim.normal}
\alias{sim.normal}
\title{This function simulates (generates) data sets by given a Confirmatory Factor Analysis model.}
\usage{
sim.normal(nd = 10, ss = 100, fcors, loading, f.loc)
}
\arguments{
\item{nd}{Number of data set, an integer.}

\item{ss}{Sample Size, an integer and larger than 10.}

\item{fcors}{Factor correlation matrix, a symmetric matrix. If one factor model is used this should be matrix(1,1,1).}

\item{loading}{Factor loading matrix. Column represent factors and non zero row represents number of items under each factor.}

\item{f.loc}{File location. Generated data sets will be saved at the user defined location.}
}
\description{
Based on a given Confirmatory Factor Analysis model, this function simulates data sets.
In each data file, the first column shows sample numbers. The second and other columns show actual simulated data sets for each item.
If the model have 2 factor and each factor as 3 items, for example, column names will be something like "ID, F1_x1, F1_x2,F1_x3,F2_x1,F2_x2,F2_x3".
On the other hand, number of rows shows the sample number of the data. Besides, there will be two more files saved in the folder.
First of them is "Model_Info.dat". This file includes factor correlation and factor loading matrices.
The second is "Data_List.dat". The file includes names of the data sets which were generated.
}
\examples{
fc<-fcors.value(nf=3, cors=c(1,.5,.6,.5,1,.4,.6,.4,1))
fl<-loading.value(nf=3, fl.loads=c(.5,.5,.5,0,0,0,0,0,0,0,0,.6,.6,.6,0,0,0,0,0,0,0,0,.4,.4))

sim.normal(nd=10, ss=1000, fcors=fc, loading<-fl,  f.loc=tempdir())
}
\author{
Fatih Orçan
}
