\name{projRead}
\alias{projRead}
\title{Project points onto the closest point on a mesh}
\usage{
projRead(lm, mesh, readnormals = TRUE, smooth = TRUE, sign = TRUE, ...)
}
\arguments{
  \item{lm}{m x 3 matrix containing 3D coordinates.}

  \item{mesh}{character: specify path to mesh file.}

  \item{readnormals}{logical: return normals of projected
  points.}

  \item{smooth}{logical: rerturn smoothed normals.}

  \item{sign}{logical: request signed distances.}

  \item{\dots}{additional arguments currently not used.}
}
\value{
if readnormals = FALSE, a m x 3 matrix containing projected
points is returned, otherwise a list, where \item{vb }{3 x
m matrix containing projected points} \item{normals }{3 x m
matrix containing normals} \item{quality }{vector
containing distances }
}
\description{
project points onto a given surface and return projected
points and normals.
}
\examples{
data(nose)
\dontrun{
repro <- projRead(shortnose.lm,shortnose.mesh)
}
}
\author{
Stefan Schlager
}
\references{
Detection of inside/outside uses the algorithm proposed in:

Baerentzen, Jakob Andreas. & Aanaes, H., 2002. Generating
Signed Distance Fields From Triangle Meshes. Informatics
and Mathematical Modelling.
}
\seealso{
\code{\link{closemeshKD}}
}
\keyword{~kwd1}
\keyword{~kwd2}

