\name{groupPCA}
\alias{groupPCA}
\title{Perform PCA based of the group means' covariance matrix}
\usage{
groupPCA(dataarray, groups, rounds = 10000, tol = 1e-10, cv = TRUE,
  mc.cores = detectCores(), weighting = TRUE)
}
\arguments{
  \item{dataarray}{Either a k x m x n real array, where k
  is the number of points, m is the number of dimensions,
  and n is the sample size. Or alternatively a n x m Matrix
  where n is the numeber of observations and m the number
  of variables (this can be PC scores for example)}

  \item{groups}{a character/factor vector containgin
  grouping variable.}

  \item{rounds}{integer: number of permutations if a
  permutation test of the euclidean distance between group
  means is requested.If rounds = 0, no test is performed.}

  \item{tol}{threshold to ignore eigenvalues of the
  covariance matrix.}

  \item{cv}{logical: requests leaving-one-out
  crossvalidation}

  \item{mc.cores}{integer: how many cores of the Computer
  are allowed to be used. Default is use autodetection by
  using detectCores() from the parallel package. Parallel
  processing is disabled on Windows due to occasional
  errors.}

  \item{weighting}{logical:weight between groups covariance
  matrix according to group sizes.}
}
\value{
\item{eigenvalues }{Non-zero eigenvalues of the groupmean
covariance matrix} \item{groupPCs }{PC-axes - i.e.
eigenvectors of the groupmean covariance matrix}
\item{Variance }{table displaying the variance explained by
eache eigenvalue} \item{Scores }{Scores of all observation
in the PC-space} \item{probs }{p-values of pairwise
groupdifferences - based on permuation testing}
\item{groupdists }{Euclidean distances between groups'
averages} \item{groupmeans }{Groupmeans} \item{Grandmean
}{Grand mean} \item{CV }{Cross-validated scores}
}
\description{
Calculate covariance matrix of the groupmeans and project
all observations into the eigenspace of this covariance
matrix. This displays a low dimensional between group
structure of a high dimensional problem.
}
\examples{
require(car)
data(iris)
vari <- iris[,1:4]
facto <- iris[,5]
pca.1 <-groupPCA(vari,groups=facto,rounds=100,mc.cores=1)

### plot scores
scatterplotMatrix(pca.1$Scores,groups=facto, ellipse=TRUE,
        by.groups=TRUE,var.labels=c("PC1","PC2","PC3"))

## example with shape data
data(boneData)
proc <- procSym(boneLM)
pop_sex <- name2factor(boneLM, which=3:4)
gpca <- groupPCA(proc$orpdata, groups=pop_sex, rounds=0, mc.cores=2)
\dontrun{
## visualize shape associated with first between group PC
dims <- dim(proc$mshape)
## calculate matrix containing landmarks of grandmean
grandmean <- matrix(gpca$Grandmean, dims[1], dims[2])
## calculate landmarks from first between-group PC
#                   (+2 and -2 standard deviations)
gpcavis2sd<- showPC(2*sd(gpca$Scores[,1]), gpca$groupPCs, grandmean)
gpcavis2sd.neg<- showPC(-2*sd(gpca$Scores[,1]), gpca$groupPCs, grandmean)
deformGrid3d(gpcavis2sd, gpcavis2sd.neg, ngrid = 0)
require(rgl)
## visualize grandmean mesh

grandm.mesh <- warp.mesh(skull_0144_ch_fe.mesh, boneLM[,,1],grandmean)
wire3d(grandm.mesh, col="white")
spheres3d(grandmean, radius=0.005)
}
}
\author{
Stefan Schlager
}
\references{
Mitteroecker P, Bookstein F 2011. Linear Discrimination,
Ordination, and the Visualization of Selection Gradients in
Modern Morphometrics. Evolutionary Biology 38:100-114.

Boulesteix, A. L. 2005: A note on between-group PCA,
International Journal of Pure and Applied Mathematics 19,
359-366.
}
\seealso{
\code{\link{CVA}}
}
\keyword{~kwd1}
\keyword{~kwd2}

