% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/restoreShapes.r
\name{restoreShapes}
\alias{restoreShapes}
\title{restore shapes from PC-Scores or similar projections}
\usage{
restoreShapes(
  scores,
  PC,
  mshape,
  sizeshape = FALSE,
  origsize = FALSE,
  meanlogCS
)
}
\arguments{
\item{scores}{vector of PC-scores, or matrix with rows containing PC-scores}

\item{PC}{Principal components (eigenvectors of the covariance matrix)
associated with 'scores'.}

\item{mshape}{matrix containing the meanshape's landmarks (used to center
the data by the PCA)}

\item{sizeshape}{logical: if TRUE, it is assumed that the data is the output of \code{procSym} run with \code{sizeshape=TRUE}.}

\item{origsize}{logical: if \code{sizeshape = TRUE}, this will apply the scaling to the original size from the corresponding entry from the PC basis matrix.}

\item{meanlogCS}{numeric: provide the average log Centroid Size of the original sample (see examples below). Only needed if \code{sizeshape = TRUE} and \code{origsize = TRUE}}
}
\value{
returns matrix or array containing landmarks
}
\description{
restore shapes from PC-Scores or similar projections
}
\details{
Rotates and translates PC-scores (or similar) derived from shape data back into
configuration space.
}
\examples{

if (require(shapes)) {
## generate landmarks using
##the first PC-score of the first specimen

proc <- procSym(gorf.dat)
lm <- restoreShapes(proc$PCscores[1,1],proc$PCs[,1],proc$mshape)
plot(lm,asp=1)

##now the first 3 scores
lm2 <- restoreShapes(proc$PCscores[1,1:3],proc$PCs[,1:3],proc$mshape)
points(lm2,col=2)

## Now restore some sizeshape data
procSize <- procSym(gorf.dat,sizeshape=TRUE)
est1 <- restoreShapes(range(procSize$PCscores[,1]),procSize$PCs[,1],procSize$mshape,
                      sizeshape=TRUE,origsize=TRUE,meanlogCS=procSize$meanlogCS)
}

}
\seealso{
\code{\link{prcomp}}, \code{\link{procSym}}

\code{\link{getPCscores}}
}
\author{
Stefan Schlager
}
