% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/points2plane.r
\name{points2plane}
\alias{points2plane}
\title{projects a 3D coordinate orthogonally onto a plane}
\usage{
points2plane(x, v1, normal = NULL, v2 = NULL, v3 = NULL)
}
\arguments{
\item{x}{3D-vector or a k x 3 matrix with 3D vectors stored in rows}

\item{v1}{point on plane}

\item{normal}{plane normal (overrides specification by v2 and v3)}

\item{v2}{if pNorm=NULL, the plane will be defined by three points \code{v1, v2, v3}}

\item{v3}{if pNorm=NULL, the plane will be defined by three points \code{v1, v2, v3}}
}
\value{
projected point
}
\description{
projects a 3D coordinate orthogonally onto a plane
}
\examples{
data(boneData)
##project rhinion onto plane spanned by Nasion and both Nariales
rpro <- points2plane(boneLM[10,,1],v1=boneLM[9,,1],v2=boneLM[3,,1],v3=boneLM[4,,1])

\dontrun{
require(rgl)
#visualize
wire3d(skull_0144_ch_fe.mesh,col="white")
##get plane normal
normal <- crossProduct(boneLM[3,,1]-boneLM[9,,1],boneLM[4,,1]-boneLM[9,,1])
#' ## get plane offset
d <- norm(points2plane(c(0,0,0),v1=boneLM[9,,1],normal=normal),"2")
spheres3d(boneLM[,,1],radius=0.5)
spheres3d(boneLM[c(3,4,9),,1],radius=0.6,col=3)
##original position of Rhinion
spheres3d(boneLM[10,,1],radius=0.6,col=2)
##projected onto plane
spheres3d(rpro,radius=0.9,col=6)
lines3d(rbind(rpro,boneLM[10,,1]),lwd=3)
##plot plane
planes3d(normal[1],normal[2],normal[3],d=d,col=2,alpha=0.5)

##now we project all points onto that plane:
spheres3d(points2plane(boneLM[,,1],v1=boneLM[9,,1],v2=boneLM[3,,1],v3=boneLM[4,,1]),col=3)

## and finally project the vertices of the mesh onto the plane
meshpro <- points2plane(vert2points(skull_0144_ch_fe.mesh),v1=boneLM[9,,1],normal=normal)
points3d(meshpro,col=2)
}
}

