% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/other_methods.R
\name{mlt}
\alias{mlt}
\alias{mltj}
\title{Model Life Tables Mortality Patterns}
\usage{
mlt(e0, sex = c("male", "female"), type = "CD_West")

mltj(e0m, e0f, ...)
}
\arguments{
\item{e0}{A time series of target life expectancy.}

\item{sex}{Either "male" or "female".}

\item{type}{Type of the model life table. Available options are \dQuote{CD_East}, \dQuote{CD_North}, 
\dQuote{CD_South}, \dQuote{CD_West}, \dQuote{UN_Chilean}, \dQuote{UN_Far_Eastern}, 
\dQuote{UN_General}, \dQuote{UN_Latin_American}, \dQuote{UN_South_Asian}.}

\item{e0m}{A time series of target male life expectancy.}

\item{e0f}{A time series of target female life expectancy.}

\item{\dots}{Additional arguments passed to the underlying function.}
}
\value{
A matrix with the predicted mortality rates. Columns correpond 
    to the values in the \code{e0} vector and rows correspond to age groups.
}
\description{
Predict age-specific mortality rates using Coale-Demeny and UN model life tables.
}
\details{
Given a level of life expectancy (e0), sex and a type of model life table, the function 
    extracts the corresponding mortality pattern from \code{\link{MLTlookup}}, 
    while interpolating between neighboring e0 groups.
    Function \code{mlt} is for one sex, while \code{mltj} can be used for both sexes.
}
\examples{
data(e0Fproj, package = "wpp2017")
country <- "Uganda"
# get target e0
e0f <- as.numeric(subset(e0Fproj, name == country)[-(1:2)])
# project into future using life table Cole-Demeny North
mx <- mlt(e0f, sex = "female", type = "CD_North")
# plot first projection in black and the remaining ones in grey 
plot(mx[,1], type="l", log="y", ylim=range(mx),
    ylab="female mx", xlab="Age", main=country)
for(i in 2:ncol(mx)) lines(mx[,i], col="grey")

}
\references{
\url{https://population.un.org/wpp/Download/Other/MLT}

Coale, A., P. Demeny, and B. Vaughn. 1983. Regional model life tables and stable 
populations. 2nd ed. New York: Academic Press.
}
\seealso{
\code{\link{mortcast}}, \code{\link{mortcast.blend}}, \code{\link{pmd}}, \code{\link{MLTlookup}}
}
