% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HMD2MH.r
\name{HMD2MH}
\alias{HMD2MH}
\title{Format data from the Human Mortality Database for use in the MortHump package}
\usage{
HMD2MH(country, year, dim = "period", xtra = FALSE, sex, min = 0,
  max = NULL, username = NULL, password = NULL, path = NULL)
}
\arguments{
\item{country}{\href{http://www.mortality.org/cgi-bin/hmd/hmd_download.php}{HMD population letter code}}

\item{year}{year (or birth cohort) for which the data is required}

\item{dim}{dimension (period or cohort)}

\item{xtra}{if TRUE extrapolates non-extinct cohorts}

\item{sex}{sex for which the data is required ("females", "males" or "total")}

\item{min}{age at which the data should be left-censored}

\item{max}{age at which the data should be right-censored}

\item{username}{personal HMD username for web access}

\item{password}{personal HMD password for web access}

\item{path}{path to the HMD folder for local access (containing the country folders)}
}
\value{
A data frame containing the following variables.
\describe{
  \item{\code{x}}{vector of ages.}
  \item{\code{d}}{vector of death counts.}
  \item{\code{n}}{vector of population exposures.}
  \item{\code{m}}{vector of death rates.}
}
}
\description{
Format data from the Human Mortality Database for use in the MortHump package
}
\details{
Two methods are available to access the data, either online or locally. Web access is advised
to guarantee the most recent data, but can be slow. For a fast access, download first the \href{http://www.mortality.org/cgi-bin/hmd/hmd_download.php}{complete
zipped data files} (choose "All countries for the HMD"), and then indicate the path to the general folder.
The data collection method will be adapted depending if you indicate a path or a username and a password.

If you choose cohort data, you have the option of either work with the observed data, or to extrapolate the non-extinct cohorts.
In the latter case, a variant of the Lee-Carter model is used to extrapolate the period mortality rates, which are used to identify cohort rates in the diagonal of the Lexis matrix.
This option uses a variant of the Lee-Carter model, namely the functional model proposed by Hyndman and Ullah (2007) and available in the \pkg{demography} package.

The list of available countries and period coverage can be found on the \href{http://www.mortality.org/cgi-bin/hmd/DataAvailability.php}{HMD website}.
This list is also accessible with the function \code{getHMDcountries()} from the \pkg{HMDHFDplus} package.

The \code{max} argument is designed to deal with either the presence of a mortality plateau among centenarians, which can be diffcult to capture with parametric models, or
a high level of stochasticity at old ages due to a small number of survivors. It is recommended to keep the value of \code{max} above 80 or 90.
}
\references{
Human Mortality Database. University of California, Berkeley (USA), and Max Planck Institute for Demographic Research (Germany). Available at \url{www.mortality.org} or \url{www.humanmortality.de}.
}
\seealso{
This function makes use of the functions \code{readHMD} and \code{readHMDweb} from the \pkg{HMDHFDplus} package.
}
