% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kweffectsize.R
\name{kweffectsize}
\alias{kweffectsize}
\title{Sample Size for the Kruskal-Wallis test.}
\usage{
kweffectsize(totsamp, shifts, distname = c("normal", "logistic"),
  targetpower = 0.8, proportions = rep(1,
  length(shifts))/length(shifts), level = 0.05)
}
\arguments{
\item{totsamp}{sample size}

\item{shifts}{The offsets for the various populations, under the alternative hypothesis.  This is used for direction on input.}

\item{distname}{The distribution of the underlying observations; normal and logistic are currently supported.}

\item{targetpower}{The distribution of the underlying observations; normal and logistic are currently supported.}

\item{proportions}{The proportions in each group.}

\item{level}{The test level.}
}
\value{
A list with components power, giving the power approximation, ncp, giving the noncentrality parameter, cv, giving the critical value, probs, giving the intermediate output from pairwiseprobability, and expect, the quantities summed before squaring in the noncentrality parameter.
}
\description{
\code{kweffectsize} approximates effect size for the Kruskal-Wallis test, 
using a chi-square approximation under the null, and a non-central chi-square approximation under the alternative.  The noncentrality parameter is calculated using alternative means and the null variance structure.
}
\details{
The standard noncentral chi-square power formula, or Monte Carlo, is used.
}
\examples{
kwpower(rep(10,3),c(0,1,2),"normal")
}
