% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NumOutputs.R
\name{GFEVDjointOrthoJLL}
\alias{GFEVDjointOrthoJLL}
\title{Orthogonalized GFEVDs for JLL models}
\usage{
GFEVDjointOrthoJLL(ModelType, ModelPara, GFEVDhoriz, FactorLabels, Economies)
}
\arguments{
\item{ModelType}{a string-vector containing the label of the model to be estimated}

\item{ModelPara}{List of model parameter estimates (See the "Optimization" function)}

\item{GFEVDhoriz}{single numerical vector conataining the desired horizon of analysis for the GFEVDs}

\item{FactorLabels}{a string-list based which contains all the labels of all the variables present in the model}

\item{Economies}{a string-vector containing the names of the economies which are part of the economic system}
}
\description{
Orthogonalized GFEVDs for JLL models
}
\references{
\itemize{
\item This function is a modified and extended version of the "fevd" function from
Smith, L.V. and A. Galesi (2014). GVAR Toolbox 2.0, available at https://sites.google.com/site/gvarmodelling/gvar-toolbox.

\item Pesaran and Shin, 1998. "Generalized impulse response analysis in linear multivariate models" (Economics Letters)
}
}
