% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/def.glm.r
\name{def.glm}
\alias{def.glm}
\title{Define a Generalized Linear Model}
\usage{
def.glm(formula, family = gaussian, weights = NULL, ...)
}
\arguments{
\item{formula}{The formula of the model to be fitted.}

\item{family}{The distribution of the response variable and the link function to be used in the model.}

\item{weights}{The prior weights to be used in the model.}

\item{...}{Addition arguments for the function \code{\link{glm}}.}
}
\description{
Define a generalized linear model. All the arguments in \code{\link{glm}} are allowed except for \code{data}. Supported types of \code{family} include \code{gaussian}, \code{binomial}, \code{poisson}, \code{Gamma} and \code{inverse.gaussian}.
}
\examples{
# A logistic regression with response R and covariates X1 and X2
mis1 <- def.glm(formula = R ~ X1 + X2, family = binomial(link = logit))
}
\seealso{
\code{\link{glm}}.
}
