% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Distributions.R
\name{distr_CFUSSD_Rand}
\alias{distr_CFUSSD_Rand}
\title{Random multivariate CFUSSD}
\usage{
distr_CFUSSD_Rand(n, d, p, a, b, Delta)
}
\arguments{
\item{n}{sample size}

\item{d}{dimension}

\item{p}{dimension of the first term of (5.5)}

\item{a}{shape  parameter of the Gamma generator}

\item{b}{scale parameter of the Gamma generator}

\item{Delta}{skewness matrix}
}
\value{
A  matrix of \eqn{n \times d} random numbers
}
\description{
Generate random d-vectors  from the multivariate Canonical Fundamental
Skew-Spherical distribution (CFUSSD)  with Gamma generator
}
\examples{
n <- 10^3; d <- 2; p <- 3 ; a <- 1; b <- 1
Lamd <-  matrix(sample(1:50-25, d*p), nrow=d)
ieg<- eigen(diag(p)+t(Lamd)\%*\%Lamd)
V <- ieg$vectors
Delta <-Lamd \%*\% V \%*\% diag(1/sqrt(ieg$values)) \%*\% t(V)
distr_CFUSSD_Rand(20,d,p,1,1,Delta)
}
\references{
Gy.Terdik, Multivariate statistical methods - Going beyond the linear,
Springer 2021, (5.36) p. 266, (see p.247 for Delta)
}
\seealso{
Other Random generation: 
\code{\link{distr_CFUSN_Rand}()},
\code{\link{distr_SkewNorm_Rand}()},
\code{\link{distr_Uni_Rand}()}

Other Multivariate distributions: 
\code{\link{distr_CFUSN_MomCum_Th}()},
\code{\link{distr_CFUSN_Rand}()},
\code{\link{distr_SkewNorm_EVSK_Th}()},
\code{\link{distr_SkewNorm_MomCum_Th}()},
\code{\link{distr_SkewNorm_Rand}()},
\code{\link{distr_UniAbs_EVSK_Th}()},
\code{\link{distr_Uni_EVSK_Th}()},
\code{\link{distr_Uni_MomCum_Th}()},
\code{\link{distr_Uni_Rand}()},
\code{\link{distr_ZabsM_MomCum_Th}()},
\code{\link{distr_Zabs_MomCum_Th}()}
}
\concept{Multivariate distributions}
\concept{Random generation}
