% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Distributions.R
\name{distr_SkewNorm_Rand}
\alias{distr_SkewNorm_Rand}
\title{Random Multivariate Skew Normal}
\usage{
distr_SkewNorm_Rand(n, omega, alpha)
}
\arguments{
\item{n}{sample size}

\item{omega}{correlation matrix   with d dimension}

\item{alpha}{shape parameter vector of dimension d}
}
\value{
A random matrix \eqn{n \times d}
}
\description{
Generate random d-vectors  from the multivariate Skew Normal distribution
}
\examples{
alpha<-c(10,5,0)
omega<-diag(3)
x<-distr_SkewNorm_Rand(20,omega,alpha)

}
\references{
Azzalini, A. with the collaboration of Capitanio, A. (2014).
The Skew-Normal and Related Families. Cambridge University Press,
  IMS Monographs series.

Gy.H.Terdik, Multivariate statistical methods - Going beyond the linear,
Springer 2021, Section 5.1.2
}
\seealso{
Other Random generation: 
\code{\link{distr_CFUSN_Rand}()},
\code{\link{distr_CFUSSD_Rand}()},
\code{\link{distr_Uni_Rand}()}

Other Multivariate distributions: 
\code{\link{distr_CFUSN_MomCum_Th}()},
\code{\link{distr_CFUSN_Rand}()},
\code{\link{distr_CFUSSD_Rand}()},
\code{\link{distr_SkewNorm_EVSK_Th}()},
\code{\link{distr_SkewNorm_MomCum_Th}()},
\code{\link{distr_UniAbs_EVSK_Th}()},
\code{\link{distr_Uni_EVSK_Th}()},
\code{\link{distr_Uni_MomCum_Th}()},
\code{\link{distr_Uni_Rand}()},
\code{\link{distr_ZabsM_MomCum_Th}()},
\code{\link{distr_Zabs_MomCum_Th}()}
}
\concept{Multivariate distributions}
\concept{Random generation}
