% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Estimation.r
\name{conv_Stand_Multi}
\alias{conv_Stand_Multi}
\title{Standardize multivariate data}
\usage{
conv_Stand_Multi(x)
}
\arguments{
\item{x}{a multivariate data matrix, sample size is the number of rows}
}
\value{
a matrix of multivariate data with null mean vector and
identity sample covariance matrix
}
\description{
For data formed by d-variate vectors x with sample covariance S and sample mean M,
it computes the values
\eqn{z=S^{-1/2}(x-M)}
}
\examples{
x<-MASS::mvrnorm(1000,c(0,0,1,3),diag(4))
z<-conv_Stand_Multi(x)
mu_z<- apply(z,2,mean)
cov_z<- cov(z)

}
