% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSADF.R
\name{bsadf}
\alias{bsadf}
\title{Critical values for backward SADF statistic sequence.}
\usage{
bsadf(m, t, adflag = 0, mflag = 1)
}
\arguments{
\item{m}{Number of Monte Carlo Simulations}

\item{t}{Sample size.}

\item{adflag}{is the lag order.}

\item{mflag}{1 for ADF with constant and whithout trend, 2 for ADF with constant and trend and 3 for ADF without constant and trend.#' @keywords AugmentedDickey-FullerTest backwardSADF MonteCarlo.}
}
\description{
Calculate critical value sequences for the backward
 sup ADF statistic sequence using Monte Carlo simulations for a sample
 generated from a Normal distribution.
}
\examples{
foo <- bsadf(m = 20, t = 50, adflag = 1, mflag = 2)
plot(foo$quantiles[2,], type = 'l')
}
\references{
Phillips, P.C. & Shi, S. & Yu, J. (2015a). "Testing for Multiple Bubbles: Historical Episodes of Exuberance and Collapse in the S&P 500". \emph{SSRN Electronic Journal}.
}
