/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.online.example.rescorer;

import com.google.common.base.Preconditions;
import net.myrrix.common.MyrrixRecommender;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.recommender.IDRescorer;

final class SimilarToItemRescorer
implements IDRescorer {
    private static final double RESCORE_RATE = 1.0;
    private final long toItemID;
    private final MyrrixRecommender recommender;

    SimilarToItemRescorer(long toItemID, MyrrixRecommender recommender) {
        Preconditions.checkNotNull(recommender);
        this.toItemID = toItemID;
        this.recommender = recommender;
    }

    @Override
    public double rescore(long itemID, double value) {
        double similarity;
        if (this.toItemID == itemID) {
            return Double.NaN;
        }
        try {
            similarity = this.recommender.similarityToItem(this.toItemID, itemID)[0];
        }
        catch (TasteException ignored) {
            return Double.NaN;
        }
        return value * (0.0 + 1.0 * similarity);
    }

    @Override
    public boolean isFiltered(long itemID) {
        return false;
    }
}

