/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.web.servlets;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.myrrix.common.LangUtils;
import net.myrrix.common.MyrrixRecommender;
import net.myrrix.common.NotReadyException;
import net.myrrix.online.RescorerProvider;
import net.myrrix.web.servlets.AbstractMyrrixServlet;
import org.apache.commons.math3.util.Pair;
import org.apache.mahout.cf.taste.common.NoSuchItemException;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.recommender.IDRescorer;
import org.apache.mahout.cf.taste.recommender.RecommendedItem;

public final class RecommendToAnonymousServlet
extends AbstractMyrrixServlet {
    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Pair<long[], float[]> itemIDsAndValue;
        String pathInfo = request.getPathInfo();
        if (pathInfo == null) {
            response.sendError(400, "No path");
        }
        Iterator<String> pathComponents = SLASH.split(pathInfo).iterator();
        try {
            itemIDsAndValue = RecommendToAnonymousServlet.parseItemValuePairs(pathComponents);
        }
        catch (NoSuchElementException nsee) {
            response.sendError(400, nsee.toString());
            return;
        }
        catch (NumberFormatException nfe) {
            response.sendError(400, nfe.toString());
            return;
        }
        if (itemIDsAndValue.getFirst().length == 0) {
            response.sendError(400, "No items");
            return;
        }
        long[] itemIDs = itemIDsAndValue.getFirst();
        float[] values = itemIDsAndValue.getSecond();
        MyrrixRecommender recommender = this.getRecommender();
        RescorerProvider rescorerProvider = this.getRescorerProvider();
        try {
            IDRescorer rescorer = rescorerProvider == null ? null : rescorerProvider.getRecommendToAnonymousRescorer(itemIDs, recommender, RecommendToAnonymousServlet.getRescorerParams(request));
            List<RecommendedItem> recommended = recommender.recommendToAnonymous(itemIDs, values, RecommendToAnonymousServlet.getHowMany(request), rescorer);
            this.output(request, response, recommended);
        }
        catch (NotReadyException nre) {
            response.sendError(503, nre.toString());
        }
        catch (NoSuchItemException nsie) {
            response.sendError(404, nsie.toString());
        }
        catch (TasteException te) {
            response.sendError(500, te.toString());
            this.getServletContext().log("Unexpected error in " + this.getClass().getSimpleName(), te);
        }
        catch (IllegalArgumentException iae) {
            response.sendError(400, iae.toString());
        }
    }

    static Pair<long[], float[]> parseItemValuePairs(Iterator<String> pathComponents) {
        ArrayList<Pair<Long, Float>> itemValuePairs = Lists.newArrayListWithCapacity(1);
        while (pathComponents.hasNext()) {
            itemValuePairs.add(RecommendToAnonymousServlet.parseItemValue(pathComponents.next()));
        }
        int size = itemValuePairs.size();
        long[] itemIDs = new long[size];
        float[] values = new float[size];
        for (int i = 0; i < size; ++i) {
            Pair itemValuePair = (Pair)itemValuePairs.get(i);
            itemIDs[i] = (Long)itemValuePair.getFirst();
            Float value = (Float)itemValuePair.getSecond();
            values[i] = value == null ? 1.0f : value.floatValue();
        }
        return new Pair<long[], float[]>(itemIDs, values);
    }

    private static Pair<Long, Float> parseItemValue(String s) {
        int equals = s.indexOf(61);
        if (equals < 0) {
            return new Pair<Long, Object>(Long.parseLong(s), null);
        }
        return new Pair<Long, Float>(Long.parseLong(s.substring(0, equals)), Float.valueOf(LangUtils.parseFloat(s.substring(equals + 1))));
    }
}

