/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.common.jdbc;

import com.google.common.base.Function;
import com.google.common.collect.ForwardingIterator;
import com.google.common.collect.Iterators;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import javax.sql.DataSource;
import org.apache.mahout.cf.taste.impl.common.jdbc.EachRowIterator;

public abstract class ResultSetIterator<T>
extends ForwardingIterator<T> {
    private final Iterator<T> delegate;
    private final EachRowIterator rowDelegate;

    protected ResultSetIterator(DataSource dataSource, String sqlQuery) throws SQLException {
        this.rowDelegate = new EachRowIterator(dataSource, sqlQuery);
        this.delegate = Iterators.transform(this.rowDelegate, new Function<ResultSet, T>(){

            @Override
            public T apply(ResultSet from) {
                try {
                    return ResultSetIterator.this.parseElement(from);
                }
                catch (SQLException sqle) {
                    throw new IllegalStateException(sqle);
                }
            }
        });
    }

    @Override
    protected Iterator<T> delegate() {
        return this.delegate;
    }

    protected abstract T parseElement(ResultSet var1) throws SQLException;

    public void skip(int n) {
        if (n >= 1) {
            try {
                this.rowDelegate.skip(n);
            }
            catch (SQLException sqle) {
                throw new IllegalStateException(sqle);
            }
        }
    }
}

