% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imports.R
\name{crossKnn}
\alias{crossKnn}
\title{Perform fast approximate K-nearest neighbor search of rows input matrix mA in rows of matrix mB.}
\usage{
crossKnn(
  mA,
  mB,
  k,
  nThreads = 10L,
  verbose = TRUE,
  indexType = "angular",
  M = 12L,
  MaxM0 = 24L,
  ef_search_multiplier = 50,
  quiet = FALSE
)
}
\arguments{
\item{mA}{Input numeric matrix of data}

\item{mB}{Input numeric matrix of data}

\item{k}{Integer number of clusters}

\item{nThreads}{Integer number of threads (default=10)}

\item{verbose}{Boolean flag for verbose output (default=FALSE)}

\item{indexType}{Metric distance type, which can be "angular" or "L2" (default="angular")}

\item{M}{Integer number of connections (default=12) The NSW graph is constructed via consecutive insertion of elements in random order by bidirectionally connecting them to the M closest neighbors from the previously inserted elements.}

\item{MaxM0}{Integer maximum number of connections that an element can have in the zero layer. (default=24) It is recommended that MaxM0 not exceed 2*M.}

\item{ef_search_multiplier}{Integer multiplier to calculate candidate nearest neighbors, set to k*ef_search_multiplier (default=50). Refer to the parameters er and efConstruction in Malkov & Yashunin (2020) doi: 10.1109/TPAMI.2018.2889473}

\item{quiet}{Boolean flag specifically for Rcpp warnings (default=FALSE)}
}
\value{
clusters per row in sparse Matrix of class "dgCMatrix" of dimensions mB rows by mA rows
}
\description{
Perform fast approximate K-nearest neighbor search of rows input matrix mA in rows of matrix mB.
}
\examples{
data(iris)
iris_df = data.matrix(iris[-5]) ## convert to a numeric matrix 
crossKnn(mA=iris_df, mB=head(iris_df, 50), 4)

}
