% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cenperm2.R
\name{cenperm2}
\alias{cenperm2}
\title{Censored two-group permutation test}
\usage{
cenperm2(y1, y2, grp, R = 9999, alternative = "two.sided", printstat = TRUE)
}
\arguments{
\item{y1}{The column of data values plus detection limits}

\item{y2}{The column of indicators, where 1 (or \code{TRUE}) indicates a detection limit in the \code{y1} column, and 0 (or \code{FALSE}) indicates a detected value in \code{y1}.}

\item{grp}{Grouping or factor variable. Can be either a text or numeric value indicating the group assignment.}

\item{R}{The number of permutations used. Default is 9999}

\item{alternative}{indicates the alternative hypothesis and must be one of "\code{two.sided}", "\code{greater}" or "\code{less}". You may also specify just the initial letter. Default is "\code{two.sided}".}

\item{printstat}{Logical \code{TRUE}/\code{FALSE} option of whether to print the resulting statistics in the console window, or not.  Default is \code{TRUE.}}
}
\value{
Permutation test results with the number of permutations, range in group means and their difference, and range in \code{p-value}.
}
\description{
Performs a permutation test of differences in means between two groups of censored data.
}
\details{
Because this is a permutation test it avoids the problem with MLE tests (\code{cen2means}) that assume a normal distribution.  No values are modeled as below zero and \code{p-values} are trustworthy. Ranges in means and p-values are due to interval-censoring of censored data means.
}
\examples{
data(PbHeron)
cenperm2(PbHeron$Liver,PbHeron$LiverCen,PbHeron$DosageGroup,alternative="t")
}
\references{
Good, P., 2000. Permutation Tests: A Practical Guide to Resampling Methods for Testing Hypotheses, 2nd ed, Springer Series in Statistics. Springer-Verlag, New York, NY. \doi{https://doi.org/10.1007/978-1-4757-3235-1}

Helsel, D.R., 2011. Statistics for Censored Environmental Data using Minitab and R, 2nd ed. John Wiley & Sons, USA, N.J.

Shapiro, S.S., Francia, R.S., 1972. An approximate analysis of variance test for normality. Journal of the American Statistical Association 67, 215–216.
}
\keyword{difference}
\keyword{permutation}
\keyword{test}
