% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nbr_lme_aov.R
\name{nbr_lme_aov}
\alias{nbr_lme_aov}
\title{Network-based R-statistics using Mixed Effects Models ANOVA}
\usage{
nbr_lme_aov(net, nnodes, idata, mod, rdm, diag = FALSE,
            nperm, thrP = 0.05, thrF = NULL, cores = NULL,
            nudist = FALSE, expList = NULL,
            verbose = TRUE, ...)
}
\arguments{
\item{net}{3D volume (2D matrices for each observation) or 2D matrix of edges as columns.}

\item{nnodes}{Number of network nodes.}

\item{idata}{Matrix or data.frame including independent variables of interest of the model.}

\item{mod}{Fixed effects, specify as a string, e.g., "~Session + Sex".}

\item{rdm}{Random effects, specify as a string, e.g., "~1+Session|id".}

\item{diag}{Logical indicating if matrix diagonal is to be included in the analysis (default: FALSE).}

\item{nperm}{Number of permutations.}

\item{thrP}{Individual edge p-value threshold (if NULL, thrF should be given).}

\item{thrF}{Individual edge F-value threshold (if NULL, thrP should be given).}

\item{cores}{Number of selected cores for parallel computing (default: NULL).}

\item{nudist}{Logical indicating if null distribution should be returned (default: FALSE).}

\item{expList}{Character string adding variable names to the varlist of 'clusterExport' (default: NULL).}

\item{verbose}{Logical indicating if messages should be printed (default: TRUE).}

\item{...}{Additional arguments to be passed to the low level 'lm' function.}
}
\value{
List containing the observed statistics and their corresponding FWE p-values,
 if requested by \emph{nudist} it will return the null distribution.
 \enumerate{
  \item Observed statistics for every individual edge: corresponding subset of connected
   nodes and strength for each model term.
  \item FWE for components: binary and strength sum, with their corresponding FWE p-value.
  \item Null Distribution: maximal component size and strength for each permutation. Only
   returned if \emph{nudist} is TRUE.
}
}
\description{
This function computes the specified (non)linear mixed models (LME) ANOVA for
 each edge in the network, and calculates the family wise error (FWE) p-value for the size
 of the clusters of connected edges that are individually below the P threshold
 (\emph{thrP}), or above the F threshold (\emph{thrF}). FWE estimation is based on the null
 distribution of the maximum size of sets of connected edges (defined as above), obtained
 with \emph{nperm} permutations of the original data.
}
\details{
It's VERY IMPORTANT when giving \emph{net} as a 2D matrix or data.frame, to be
 completely sure that column distribution fits that of the upper triangle indices of an
 \emph{nnodes} * \emph{nnodes} matrix. This may be verified through the edge indices, e.g.,
 "which(upper.tri(matrix(nrow = nnodes, ncol = nnodes)), arr.ind = T)" (see vignette NBR-LME
 for more details).

Regarding \emph{nperm}, I suggest first setting it to small values (5 or 10) in order to test that
everything runs fine. After that, set \emph{nperm} to 1000 or larger number to decrease the
margin of error of the FWE p-value (see \url{https://fsl.fmrib.ox.ac.uk/fsl/fslwiki/Randomise/Theory#Conditional_Monte_Carlo_Permutation_Tests}
to explore the behavior of FWE p-value as a function of \emph{nperm}).
}
\examples{
data(voles)
\donttest{
nbr_result <- nbr_lme_aov(net = voles[,-(1:3)],
  nnodes = 16, idata = voles[,1:3],
  mod = "~ Session*Sex",
  rdm = "~ 1+Session|id",
  nperm = 5, na.action = na.exclude
  )
show(nbr_result)
}

}
