% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dependencies.R
\name{NFCP.Parameters}
\alias{NFCP.Parameters}
\title{Specify parameters of N-factor model}
\usage{
NFCP.Parameters(
  N.factors,
  GBM,
  Initial.State,
  S.Constant,
  N.contracts = NULL,
  verbose = TRUE
)
}
\arguments{
\item{N.factors}{\code{numeric}. Number of state variables in the spot price process.}

\item{GBM}{\code{logical}. If \code{GBM = T}, factor 1 of the model is assumed to follow a Brownian Motion, inducing a unit-root in the spot price process.}

\item{Initial.State}{\code{logical}. If \code{Initial.State = T}, the initial state vector is specified as unknown parameters of the commodity pricing model.}

\item{S.Constant}{\code{logical}. If \code{S.Constant = T}, the white noise of observable contracts are assumed and identical (and independent).}

\item{N.contracts}{\code{numeric}. The number of individual observation white noise terms when \code{S.Constant = F}. Optional when \code{S.Constant = T}. When \code{N.contracts = 0},
the value of \code{NFCP.Parameters} returns a vector without any "sigma.contract" or "sigma.contracts" elements.}

\item{verbose}{\code{logical}. If \code{verbose = T}, the specified N-factor model is printed when the function is called.}
}
\value{
A vector of parameter names for a specified N-factor spot price process. This vector is ideal for application within many other functions within the \code{NFCP} package
}
\description{
\loadmathjax
the \code{NFCP.Parameters} function specifies the parameters of
a commodity pricing model under the N-factor framework first described by Cortazar and Naranjo (2006).
This function is a recommended starting position for the application of N-factor models within the \code{NFCP} package.
}
\details{
\bold{The N-factor model}
The N-factor model was first presented in the work of Cortazar and Naranjo (2006, equations 1-3). The N-factor framework
describes the spot price process of a commodity as the correlated sum of \mjeqn{N}{N} state variables \mjeqn{x_t}{x[t]}.

When \code{GBM = TRUE}:
\mjdeqn{log(S_{t}) = \sum_{i=1}^N x_{i,t}}{log(S[t]) = sum_{i=1}^n x[i,t]}
When \code{GBM = FALSE}:
\mjdeqn{log(S_{t}) = E + \sum_{i=1}^N x_{i,t}}{log(S[t]) = E + sum_{i=1}^n x[i,t]}

Additional factors within the spot-price process are designed to result in additional flexibility, and possibly fit to the observable term structure, in
the spot price process of a commodity. The fit of different N-factor models, represented by the log-likelihood can be directly compared with statistical
testing possible through a chi-squared test.

Flexibility in the spot price under the N-factor framework allows the first factor to follow a Brownian Motion or Ornstein-Uhlenbeck process to induce a unit root.
In general, an N-factor model where \code{GBM = T}
allows for non-reversible behaviour within the price of a commodity, whilst \code{GBM = F} assumes that there is a long-run equilibrium that
the commodity price will revert to in the long-term.


State variables are thus assumed to follow the following processes:

When \code{GBM = TRUE}:
\mjdeqn{dx_{1,t} = \mu^*dt + \sigma_{1} dw_{1}t}{dx[1,t] = mu^* dt + sigma[1] dw[1]t}

When \code{GBM = FALSE}:
\mjdeqn{dx_{1,t} = - (\lambda_{1} + \kappa_{1}x_{1,t})dt + \sigma_{1} dw_{1}t}{dx[1,t] = - (lambda[1] + kappa[1] x[1,t]) dt + sigma[1] dw[t]t}

And:
\mjdeqn{dx_{i,t} =_{i\neq 1} - (\lambda_{i} + \kappa_{i}x_{i,t})dt + \sigma_{i} dw_{i}t}{dx[i,t] =_(i != 1) - (lambda[i] + kappa[i] x[i,t]dt + sigma[i] dw[i]t)}

where:
\mjdeqn{E(w_{i})E(w_{j}) = \rho_{i,j}}{E(w[i])E(w[j])}

The following constant parameters are defined as:

\code{var} \mjeqn{\mu}{mu}:  long-term growth rate of the Brownian Motion process.

\code{var} \mjeqn{E}{E}: Constant equilibrium level.

\code{var} \mjeqn{\mu^*=\mu-\lambda_1}{mu^* = mu-lambda[1]}: Long-term risk-neutral growth rate

\code{var} \mjeqn{\lambda_{i}}{lambda[i]}: Risk premium of state variable \mjeqn{i}{i}.

\code{var} \mjeqn{\kappa_{i}}{kappa[i]}: Reversion rate of state variable \mjeqn{i}{i}.

\code{var} \mjeqn{\sigma_{i}}{sigma[i]}: Instantaneous volatility of state variable \mjeqn{i}{i}.

\code{var} \mjeqn{\rho_{i,j} \in [-1,1]}{rho[i,j] in [-1,1]}: Instantaneous correlation between state variables \mjeqn{i}{i} and \mjeqn{j}{j}.

\bold{Measurement Error}:

The Kalman filtering algorithm assumes a given measure of measurement error (ie. matrix \mjeqn{H}{H}). Measurement errors can be interpreted as error in the
model's fit to observed prices, or as errors in the reporting of prices (Schwartz and Smith, 2000) and are assumed independent.

\code{var} \mjeqn{s_i}{s[i]} Observation error of contract \mjeqn{i}{i}.

When \code{S.Constant = T}, the values of parameter \mjeqn{s_i}{s[i]} are assumed constant and equal to parameter object 'sigma.contracts'. When \code{S.Constant = F}, observation errors are assumed unique, where the error of
futures contracts \mjeqn{s_i}{s[i]} is equal to parameter object \code{'sigma.contract_'} [i] (i.e. \code{'sigma.contract_1'}, \code{'sigma.contract_2'}, ...).


When \code{N.contracts = 0}, "sigma.contract" parameters are not returned within the parameter vector.

\bold{Diffuse Assumption}:
If \code{Initial.State = F}, a 'diffuse' assumption is made within Kalman filtering and parameter estimation functions (See \code{NFCP.MLE} or \code{NFCP.Kalman.filter} for more information)
}
\examples{
##Generate parameter of a Two-factor model Crude Oil model
##as first presented by Schwartz and Smith (2000):
SS.Oil.Two.Factor.parameters <- NFCP.Parameters(N.factors = 2,
                                                      GBM = TRUE,
                                                      Initial.State = FALSE,
                                                      S.Constant = FALSE,
                                                      N.contracts = 5)
print(SS.Oil.Two.Factor.parameters)
}
\references{
Schwartz, E. S., and J. E. Smith, (2000). Short-Term Variations and Long-Term Dynamics in Commodity Prices. \emph{Manage. Sci.}, 46, 893-911.

Cortazar, G., and L. Naranjo, (2006). An N-factor Gaussian model of oil futures prices. \emph{Journal of Futures Markets: Futures, Options, and Other Derivative Products}, 26(3), 243-268.
}
