% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allGenerics.R, R/allMethods.R
\name{chmAddSpecificAxisTypeFunction}
\alias{chmAddSpecificAxisTypeFunction}
\alias{chmAddSpecificAxisTypeFunction,ngchm,character,character,character,ngchmJS-method}
\alias{chmAddSpecificAxisTypeFunction,ngchm,character,character,character,character-method}
\title{Add a CHM-specific axis type function to a NGCHM.}
\usage{
chmAddSpecificAxisTypeFunction(chm, where, type, label, func)

\S4method{chmAddSpecificAxisTypeFunction}{ngchm,character,character,character,ngchmJS}(chm, where, type, label, func)

\S4method{chmAddSpecificAxisTypeFunction}{ngchm,character,character,character,character}(chm, where, type, label, func)
}
\arguments{
\item{chm}{The chm to add the axis type to.}

\item{where}{The axis to add the axis type to. Must be either "row", "column", or "both".}

\item{type}{The type expected by the specified function.}

\item{label}{The label to use if and when the function is added to the menu.}

\item{func}{A javascript function that accepts a list of values of that type.
If a string is provided, the function is obtained by calling chmGetFunction.}
}
\value{
The extended chm.
}
\description{
Adds a CHM-specific axis type function to a Next Generation Clustered Heat Map (NGCHM) and
returns the extended CHM.  Multiple axis type functions may be added to either axis.
When the NGCHM is made, any specific Axis functions matching the specified axis type will be
automatically added to the appropriate axis menu.
}
\seealso{
\code{\link[=chmListTypes]{chmListTypes()}}

\linkS4class{ngchmAxisType}
}
