% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{chmNewDataLayer}
\alias{chmNewDataLayer}
\title{Create a new Data Layer for a NGCHM.}
\usage{
chmNewDataLayer(label, data, colors, summarizationMethod, cuts_color)
}
\arguments{
\item{label}{The name under which the data layer will be displayed to the user.}

\item{data}{A matrix containing the data to display. Must have rownames and colnames.}

\item{colors}{A color map specifying how the data should be rendered.  If omitted or NULL,
a default green-black-red color map will be estimated from the data.}

\item{summarizationMethod}{The method to use when summarizing multiple data points per pixel.  Possible values are average (default), sample, and mode.}

\item{cuts_color}{color of cuts}
}
\value{
An object of class ngchmLayer
}
\description{
This function creates a new Data Layer suitable for adding to a Next Generation Clustered Heat Map.
}
\examples{
noise <- matrix(runif(1000) + runif(1000 * 1000), nrow = 1000)
rownames(noise) <- sprintf("Row\%d", 1:nrow(noise))
colnames(noise) <- sprintf("Col\%d", 1:ncol(noise))
noise.colors <- chmNewColorMap(c(0, 1, 2),
  c("green", "black", "red"),
  missing.color = "yellow"
)
layer <- chmNewDataLayer("Noisy Data", noise, noise.colors)

}
\seealso{
\linkS4class{ngchmLayer}

\code{\link[=chmNewColorMap]{chmNewColorMap()}}

\code{\link[=chmAddLayer]{chmAddLayer()}}
}
