## ----nlmr_bestiary, echo=FALSE, message=FALSE, results='hide', cache = TRUE----
# load packages ----
library(NLMR)
library(ggplot2)
library(viridis)
library(lemon)

# create landscapes
set.seed(5)
percolation <- nlm_percolation(100,100,0.4, resolution = 10)
random <- nlm_random(100,100, resolution = 10)
distagrad <- nlm_distancegradient(100, 100, origin = c(10,15,10,15), resolution = 10)
edgy <- nlm_edgegradient(100,100, 90, resolution = 10)
planary <- nlm_planargradient(100,100, resolution = 10)
randomRecClustery <- nlm_randomrectangularcluster(100, 100, minL = 8, maxL = 16, rescale = FALSE, resolution = 10)
randomElementy <- nlm_randomelement(100,100, n = 90, resolution = 10)
randomClustery <- nlm_randomcluster(100,100, p = 0.5, resolution = 10)
randomMPD <- nlm_mpd(nCol = 100, nRow = 100, roughness = 0.7, resolution = 7.874017)
gaussian <- nlm_gaussianfield(nCol = 100, nRow = 100, 35, resolution = 10)
gaussian_linear <- nlm_gaussianfield(nCol = 100, nRow = 100, 35, direction = "linear", resolution = 10)
fBm <- nlm_fBm(nCol = 50, nRow = 50, H = 0.7, resolution = 20)
mosaic <- nlm_mosaicfield(nCol = 100, nRow = 100, n = 20, resolution = 10)
neighboorcluster <- nlm_neigh(nCol = 50, nRow = 50, p_neigh = 0.75, categories = 5, p_empty = 0.01, neighborhood = "Von-Neumann", resolution = 20, proportions =c(0.25, 0.05, 0.1, 0.3, 0.3))
curds <- nlm_curds(p = c(0.33, 0.33, 0.33), s = c(32, 8, 4), ext = 1000)
poly_scapes <- nlm_polylands(nCol = 50, nRow = 50, germs = 20, resolution = 20)

## ----dependson='nlmr_bestiary', echo=FALSE, message=FALSE, results='hide', fig.width = 20, fig.height=22, dpi = 300, fig.align='center'----
library(NLMR)
library(ggplot2)
library(viridis)
library(lemon)
# transform rasters to long data frame to use facets

## first transform to SpatialPixelsDataFrame to have a transformation to long format
percolation_spdf       <- as(percolation, "SpatialPixelsDataFrame")
random_spdf            <- as(random, "SpatialPixelsDataFrame")
distagrad_spdf         <- as(distagrad, "SpatialPixelsDataFrame")
edgy_spdf              <- as(edgy, "SpatialPixelsDataFrame")
planary_spdf           <- as(planary, "SpatialPixelsDataFrame")
randomRecClustery_spdf <- as(randomRecClustery, "SpatialPixelsDataFrame")
randomElementy_spdf    <- as(randomElementy, "SpatialPixelsDataFrame")
randomClustery_spdf    <- as(randomClustery, "SpatialPixelsDataFrame")
randomMPD_spdf         <- as(randomMPD, "SpatialPixelsDataFrame")
gaussian_spdf          <- as(gaussian, "SpatialPixelsDataFrame")
gaussian_linear_spdf          <- as(gaussian_linear, "SpatialPixelsDataFrame")
fBm_spdf          <- as(fBm, "SpatialPixelsDataFrame")
mosaic_spdf          <- as(mosaic, "SpatialPixelsDataFrame")
neigh_spdf          <- as(neighboorcluster, "SpatialPixelsDataFrame")
curds_spdf          <- as(curds, "SpatialPixelsDataFrame")
poly_spdf          <- as(poly_scapes, "SpatialPixelsDataFrame")



## transform to dataframes and give new row that contains name of the algorithm that produced the landscape
percolation_df <- as.data.frame(percolation_spdf)
percolation_df[,4] <- "Percolation"

random_df <- as.data.frame(random_spdf)
random_df[,4] <- "Random"

edgy_df <- as.data.frame(edgy_spdf)
edgy_df[,4] <- "Edge gradient"

distagrad_df <- as.data.frame(distagrad_spdf)
distagrad_df[,4] <- "Distance gradient"

planary_df <- as.data.frame(planary_spdf)
planary_df[,4] <- "Planar gradient"

randomRecClustery_df <- as.data.frame(randomRecClustery_spdf)
randomRecClustery_df[,4] <- "Random-rectangalur cluster"

randomElementy_df <- as.data.frame(randomElementy_spdf)
randomElementy_df[,4] <- "Random elements"

randomClustery_df <- as.data.frame(randomClustery_spdf)
randomClustery_df[,4] <- "Random cluster"

randomMPD_df <- as.data.frame(randomMPD_spdf)
randomMPD_df[,4] <- "Midpoint displacement"

gaussian_df <- as.data.frame(gaussian_spdf)
gaussian_df[,4] <- "Gaussian field"
names(gaussian_df)[1] <- "layer"
# gaussian_df[,c(2,3)] <- gaussian_df[,c(2,3)] / 100


gaussian_linear_df <- as.data.frame(gaussian_linear_spdf)
gaussian_linear_df[,4] <- "Gaussian field - linear trend"
names(gaussian_linear_df)[1] <- "layer"
# gaussian_linear_df[,c(2,3)] <- gaussian_linear_df[,c(2,3)] / 100

fbm_df <- as.data.frame(fBm_spdf)
fbm_df[,4] <- "Fractional Brownian Motion"

mosaic_df <- as.data.frame(mosaic_spdf)
mosaic_df[,4] <- "Mosaic random field - 20 steps"
names(mosaic_df)[1] <- "layer"

neigh_df <- as.data.frame(neigh_spdf)
neigh_df[,4] <- "Random Neighborhood"

curds_df <- as.data.frame(curds_spdf)
curds_df[,4] <- "Hierarchical Curdling"


poly_df <- as.data.frame(poly_spdf)
poly_df[,4] <- "Polygonal landscapes"
names(poly_df)[1] <- "layer"

## bind all of them together
nlm_df <- rbind(percolation_df,
                random_df,
                edgy_df,
                distagrad_df,
                planary_df,
                randomRecClustery_df,
                randomClustery_df,
                randomElementy_df,
                randomMPD_df,
                gaussian_df,
                gaussian_linear_df,
                fbm_df,
                mosaic_df,
                neigh_df, 
                curds_df,
                poly_df)

## rename columns
colnames(nlm_df) <- c("value", "x", "y", "Type")

# Plot the rasters as facets
nlmr_bestiary <- ggplot2::ggplot(nlm_df, aes(x=x, y=y)) +
  ggplot2::geom_raster(aes(fill=value), alpha=0.8) +
  facet_wrap( ~ Type, ncol = 4, scales = "fixed") +
  ggplot2::coord_equal() +
  ggplot2::labs(x = "Easting",
                y = "Northing") +
  ggplot2::theme(
    legend.position = "bottom",
    text = ggplot2::element_text(color = "#22211d"),
    axis.line = ggplot2::element_line(),
    axis.ticks.length = ggplot2::unit(.15, "cm"),
    axis.ticks = ggplot2::element_line(),
    panel.background=element_blank(),
    panel.border=element_blank(), # bg of the panelt
    panel.grid.major = element_blank(), # get rid of major grid
    panel.grid.minor = element_blank(), # get rid of minor grid
    aspect.ratio=1
  ) +
  viridis::scale_fill_viridis(
    option = "A",
    direction = -1,
    na.value = "transparent",
    name = "Z",
    guide = ggplot2::guide_colorbar(
      direction = "horizontal",
      barheight = ggplot2::unit(4, units = "mm"),
      barwidth = ggplot2::unit(100, units = "mm"),
      draw.ulim = FALSE,
      title.position = "top",
      title.hjust = 0.5,
      label.hjust = 0.5
    )) +
  coord_capped_cart(
    xlim = c(0, 1000), ylim = c(0, 1000), left = "both", bottom = "both")

nlmr_bestiary <- nlmr_bestiary + theme(text = element_text(size = 27),
                                       axis.text.x = element_text(size = 25))

print(nlmr_bestiary)

## ----dependson='nlmr_bestiary', echo=FALSE, message=FALSE, results='hide', fig.width = 20, fig.height=7, dpi = 300, fig.align='center'----
library(NLMR)
library(ggplot2)
library(viridis)
library(lemon)
merge_1 <- util_merge(gaussian_linear, randomRecClustery)
merge_2 <- util_merge(edgy, planary)
merge_3 <- util_merge(planary, randomElementy)
merge_4 <- util_merge(gaussian, randomClustery)

# transform rasters to long data frame to use facets

## first transform to SpatialPixelsDataFrame to have a transformation to long format
merge_1_spdf <- as(merge_1, "SpatialPixelsDataFrame")
merge_2_spdf <- as(merge_2, "SpatialPixelsDataFrame")
merge_3_spdf <- as(merge_3, "SpatialPixelsDataFrame")
merge_4_spdf <- as(merge_4, "SpatialPixelsDataFrame")

## transform to dataframes and give new row that contains name of the algorithm that produced the landscape
merge_1_df <- as.data.frame(merge_1_spdf)
merge_1_df[,4] <- "Gaussian linear + Random Rectangular Cluster"

merge_2_df <- as.data.frame(merge_2_spdf)
merge_2_df[,4] <- "Edge gradient + Planar gradient"

merge_3_df <- as.data.frame(merge_3_spdf)
merge_3_df[,4] <- "Planar gradient + Random Element"

merge_4_df <- as.data.frame(merge_4_spdf)
merge_4_df[,4] <- "Gaussian fields + Random Cluster"


## bind all of them together
nlm_df <- rbind(merge_1_df,
                merge_2_df,
                merge_3_df,
                merge_4_df)

## rename columns
colnames(nlm_df) <- c("value", "x", "y", "Type")

# Plot the rasters as facets
nlmr_merges <- ggplot2::ggplot(nlm_df, aes(x=x, y=y)) +
  ggplot2::geom_raster(aes(fill=value), alpha=0.8) +
  facet_wrap( ~ Type, ncol = 4, scales = "fixed") +
  ggplot2::coord_equal() +
  ggplot2::labs(x = "Easting",
                y = "Northing") +
  ggplot2::theme(
    legend.position = "bottom",
    text = ggplot2::element_text(color = "#22211d"),
    axis.line = ggplot2::element_line(),
    axis.ticks.length = ggplot2::unit(.15, "cm"),
    axis.ticks = ggplot2::element_line(),
    panel.background=element_blank(),
    panel.border=element_blank(), # bg of the panelt
    panel.grid.major = element_blank(), # get rid of major grid
    panel.grid.minor = element_blank(), # get rid of minor grid
    aspect.ratio=1
  ) +
  viridis::scale_fill_viridis(
    option = "A",
    direction = -1,
    na.value = "transparent",
    name = "Z",
    guide = ggplot2::guide_colorbar(
      direction = "horizontal",
      barheight = ggplot2::unit(4, units = "mm"),
      barwidth = ggplot2::unit(100, units = "mm"),
      draw.ulim = FALSE,
      title.position = "top",
      title.hjust = 0.5,
      label.hjust = 0.5
    )) +
  coord_capped_cart(
    xlim = c(0, 1000), ylim = c(0, 1000), left = "both", bottom = "both")

nlmr_merges <- nlmr_merges + theme(text = element_text(size = 27),
                                       axis.text.x = element_text(size = 25))

print(nlmr_merges)

