% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NMproject-options.R
\docType{data}
\name{parallel_execute}
\alias{parallel_execute}
\title{Generic execute command for parallelised runs}
\format{
An object of class \code{character} of length 1.
}
\usage{
parallel_execute
}
\value{
A \code{character} object.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Character to be used with the \code{\link[=cmd]{cmd()}} function to launch a parallelised run.
}
\details{
Requires \code{cores} and \code{parafile} fields to be set.
}
\examples{

# create example object m1 from package demo files
exdir <- system.file("extdata", "examples", "theopp", package = "NMproject")
m1 <- new_nm(run_id = "m1", 
             based_on = file.path(exdir, "Models", "ADVAN2.mod"),
             data_path = file.path(exdir, "SourceData", "THEOPP.csv")) \%>\%
  cmd(parallel_execute) \%>\%
  parafile("/opt/NONMEM/nm75/run/mpilinux8.pnm") \%>\%
  cores(8)
  
cmd(m1)

m2 <- m1 \%>\% child("m2") ## inherits same command as above

parallel_execute ## view the character to see how psn interfaces with SGE
}
\seealso{
\code{\link[=nm_getsetters]{nm_getsetters()}}.
}
\keyword{datasets}
