% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Correlation.R
\name{VN.cor}
\alias{VN.cor}
\title{VN Correlation}
\usage{
VN.cor(x, y, order = ceiling(log10(length(x))), degree = ifelse(length(x) <
  100, 0, 1))
}
\arguments{
\item{x}{Variable 1}

\item{y}{Variable 2}

\item{order}{Number of partial moment quadrants to be generated}

\item{degree}{Defaults to 0 for smaller number of observations}
}
\description{
Returns the nonlinear correlation coefficient based on partial moment quadrants measured by frequency or area.  Degree = 0 is frequency, degree = 1 is area.
}
\examples{
set.seed(123)
x<-rnorm(100); y<-rnorm(100)
\dontrun{VN.cor(x,y)}
}
\author{
Fred Viole, OVVO Financial Systems
}
\references{
Viole, F. and Nawrocki, D. (2013) "Nonlinear Nonparametric Statistics: Using Partial Moments"
\url{http://amzn.com/1490523995}
}
\keyword{correlation}

