% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Feature_probability.R
\name{NNS.Feature.prob}
\alias{NNS.Feature.prob}
\title{NNS Feature Probability}
\usage{
NNS.Feature.prob(x, y, threshold = 0, point.est = NULL)
}
\arguments{
\item{x}{Complete cleaned dataset in matrix form.}

\item{y}{Column of data to be classified.}

\item{threshold}{Sets the correlation threshold for independent variables.  Defaults to 0.}

\item{point.est}{IV data point(s) to be classified, in matrix form.}
}
\value{
Returns variables, \code{"MSE"} mean squared error, \code{"Fitted"} for only the fitted values of the DV, and  \code{"Point.est"} for predicted values.
}
\description{
Classifies data based on feature probabilities.
}
\examples{
## Using 'iris' dataset where predictive attributes are columns 1:4, and the class is column 5.
NNS.Feature.prob(iris,5)

## To call mean squared error
NNS.Feature.prob(iris,5)$MSE

## To call fitted values
NNS.Feature.prob(iris,5)$Fitted

## To generate a single predicted value
NNS.Feature.prob(iris,5, point.est=cbind(5.1,3.5,1.4,0.2))$Point.est

## To generate multiple predicted values
NNS.Feature.prob(iris,5, point.est=(iris[1:10,1:4]))$Point.est
}
\author{
Fred Viole, OVVO Financial Systems
}
\keyword{classifier}

