% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/NNTintervals.R
\name{NNTintervalsProspective}
\alias{NNTintervalsProspective}
\title{NNTintervalsProspective}
\usage{
NNTintervalsProspective(Npositives, Nnegatives, NtruePositives, NtrueNegatives,
  prev = 0.15, alpha = 0.025, prior = c(1/2, 1/2))
}
\arguments{
\item{Npositives}{Total number of observed positives.}

\item{Nnegatives}{Total number of observed negatives.}

\item{NtruePositives}{Observed or anticipated number of "BestToTreat" among the positives.}

\item{NtrueNegatives}{Observed or anticipated number of "BestToWait"  among the negatives.}

\item{prev}{= 0.15 Prevalence of "BestToTreat" characteristic.}

\item{alpha}{= 0.025 Significance level (one side).}

\item{prior}{Beta parameters for prior. Default is the Jeffreys prior = c(1/2,1/2). Jaynes prior = c(0,0) won't work when #fp=1.}
}
\value{
The Bayesian predictive intervals for NNTpos and NNTneg. These are obtained from predictive intervals
for PPV and NPV, based on Jeffreys' beta(1/2,1/2) prior.
}
\description{
Produce Bayesian and classical intervals for NNT from
observations in a prospective study.
Useful for "anticipated results" when designing a study,
The setting: patients will be tested immediately, and followed to determine the BestToTreat/BestToWait classification.
as well as analyzing study results.
There were (or will be) Npositives patients with a positive test, Nnegatives with a negative test.
The observed NNTs in each group were (or will be) NNTpos and NNTneg.
}

