% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/achievable.se.sp.R
\name{achievable.se.sp}
\alias{achievable.se.sp}
\title{achievable.se.sp(): target sensitivity and specificity for a retrospective study.}
\usage{
achievable.se.sp(the.prev = 0.5, axes = c("pv", "NNT"),
  sesp.seq = seq(0.5, 1, 0.1), drawNNTaxes = TRUE, drawPVaxes = FALSE,
  drawArrows = TRUE, drawTable = TRUE, latexTable = TRUE,
  placePointLabels = TRUE, cexText = 0.5, cexSubtitle = 0.5,
  cexTitle = 0.7, y0arrow = 0.25, lwdArrow = 1, ltyArrow = 2,
  title = FALSE, mtext = FALSE, contours = TRUE, ...)
}
\arguments{
\item{the.prev}{Prevalence (prior probability)}

\item{axes}{Should the axes be predictive values ("pv") or NNT values? Default is "pv".}

\item{sesp.seq}{Sequence of values at which the sensitivity and specificity will be explored.}

\item{drawNNTaxes}{(default=TRUE) Option for tweaking the plot.}

\item{drawPVaxes}{(default=FALSE) Option for tweaking the plot.}

\item{drawArrows}{(default=TRUE) Arrow option; deprecated.}

\item{drawTable}{(default=TRUE) Option for tweaking the plot.}

\item{latexTable}{(default=TRUE) Option for tweaking the plot.}

\item{placePointLabels}{(default=TRUE)  Write A, B, C, ... in circles where sensitivity=specificity.}

\item{cexText}{(default=0.5) Option for tweaking the plot.}

\item{cexSubtitle}{(default=0.5) Option for tweaking the plot.}

\item{cexTitle}{(default=0.7) Option for tweaking the plot.}

\item{y0arrow}{(default=0.25) Arrow option; deprecated.}

\item{lwdArrow}{(default=1) Arrow option; deprecated.}

\item{ltyArrow}{(default=2) Arrow option; deprecated.}

\item{title}{(default=FALSE) Option for tweaking the plot.}

\item{mtext}{(default=FALSE) Option for tweaking the plot.}

\item{contours}{(default=TRUE) Option for tweaking the plot.}

\item{...}{Options to pass to plot.default()}
}
\value{
The predictive values when sensitivity equals specificity:  sesp.to.pv(cbind(sesp.seq,sesp.seq), prev=the.prev))
}
\description{
For a retrospective study design, given a prevalence value,
produce a plot displaying the achievable contours of
either predictive values or NNT values.
The calculation uses the "contra-Bayes" theorem, sesp.from.pv.
}

