% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sesp-pv-NNT.R
\name{sesp.from.pv.feasible}
\alias{sesp.from.pv.feasible}
\title{sesp.from.pv.feasible}
\usage{
sesp.from.pv.feasible(ppv, npv, prev, feasible = TRUE)
}
\arguments{
\item{ppv}{Positive predictive value}

\item{npv}{Negative predictive value}

\item{prev}{Prevalence (prior probability)}

\item{feasible}{Only return results in [0,1]. Default=TRUE}
}
\value{
c(ppv=ppv, npv=npv, sp=sp, se=se)
}
\description{
Computes sensitivity and specificity from  predictive values.
}
\details{
NNT stands for Number Needed to Treat.  We have a range, such that
if NNT < NNTpos, all patients will be treated, if NNT > NNTneg then all
patients will not be treated. Suppose N=NNTpos is the number of patients such
that if N pts are positive,one will be a true positive. The "eq" means that we
choose NNTpos so that treating all or not treating all would be equivalent.
E(loss | treat) = (NNTpos-1) * L[A,H]  = E(loss | wait) = 1 * L[W,D] Actually
we choose N SMALLER so that TREATing is definitely, comfortably the right
thing. E(loss | treat) = (NNTpos-1) * L[A,H]  <<  E(loss | wait) = 1 * L[W,D]
Suppose N=NNTneg is the number of patients such that if N pts are negative, one
will be a false negative. The "eq" means that we choose NNTneg so that treating
all or not treating any would be equivalent. E(loss | treat) = (NNTneg-1) *
L[A,H]  = E(loss | wait) = 1 * L[W,D] Actually we choose N LARGER so that
WAITing is definitely, comfortably the right thing. E(loss | treat) =
(NNTpos-1) * L[A,H]  >> E(loss | wait) = 1 * L[W,D]
}

