% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNSummary.R
\name{NNsummary}
\alias{NNsummary}
\title{Summarize Calculations of RMSE, MSE, MAE, and WAE}
\usage{
NNsummary(y_pred, y0, time, dgts = 4)
}
\arguments{
\item{y_pred}{numeric vector of the predicted values}

\item{y0}{numeric vector of the observed values}

\item{time}{numeric value of time}

\item{dgts}{integer value for how many digits to round to, see \code{\link{round}}}
}
\value{
A vector of RMSE, MSE, MAE, WAE, and time values for a single iteration.
}
\description{
Summarize measures of fit and time for a single training. Measures of fit 
include the Root Mean Squared Error (RMSE), the Mean Squared Error (MSE), 
the Mean Absolute Error (MAE), and the Worst Absolute Error (WAE) rounded
by default to 4 digits and set to \code{na.rm = TRUE}. See more at \code{\link{funRMSE}}. 
The summary can also include the results of time from \code{\link{getTimer}} in
NNbenchmark or the result of \code{\link{timediff}}.
}
\examples{
## With 2019 legacy code, no longer usable with 2020 trainPredict
old <- options("digits.secs" = 4)
timeTT <- createTimer()

timeTT$start("event")
y0 <- 1:19
y_pred <- y0 + rnorm(length(y0), sd = 0.3)
timeTT$stop("event") 

time <- getTimer(timeTT)

NNsummary(y_pred, y0, time[,4], 4)

## With 2020 code
timestart()
y0 <- 1:19
y_pred <- y0 + rnorm(length(y0), sd = 0.3)
time <- timediff()

NNsummary(y_pred, y0, time, 4)

options(old)      
  
}
