% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_spatial.R
\name{plot_spatial}
\alias{plot_spatial}
\title{geo-spatial heat map of weather data}
\usage{
plot_spatial(online = TRUE, Date = "2017-01-01", measure = "t_max")
}
\arguments{
\item{online}{if TRUE(default),realtime data is pulled from the API. if FALSE, data is pulled from sample offline database}

\item{Date}{Beginning of date range. Default: 2017-01-01}

\item{measure}{metric for which geo-spatial heat map is needed. Default: "t_max"}
}
\value{
geo-spatial heat map for a given date and measure across all NOAA weather stations
}
\description{
generate geo-spatial heat map for a given date and measure across all NOAA weather stations
}
\examples{
\dontrun{
plot_spatial(online=FALSE,
Date="2017-01-10",
measure="t_max")
plot_spatial(online=TRUE,
Date="2017-01-10",
measure="t_official")
}
}
\author{
Vikramjeet Singh (vjs)
}
