% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/myFUN.R
\name{npmleEM}
\alias{npmleEM}
\title{Implements the full likelihood approach based on the EM algorithm for estimating signal proportion and density}
\usage{
npmleEM(y, x, level = 0.05, initp = 1)
}
\arguments{
\item{y}{The observed vector of z-scores.}

\item{x}{The \eqn{n\times p} data matrix, where \eqn{n} mist be equal to thelength of y. If you are interested in the intercept, you must add a column of \eqn{1's} to \eqn{x}.}

\item{level}{The level at which the false discovery rate is to be controlled. Should be a scalar in \eqn{[0,1]}. Default set to \eqn{0.05}.}

\item{initp}{The initialization method for the EM algorithm. It should be either \eqn{1,2,3} or \eqn{4}. \emph{1} indicates a marg1() initialization, \emph{2} indicates a marg2() initialization, \emph{3} indicates a FDRreg() initialization (see \strong{Details} and \strong{References}) and \emph{4} chooses that initialization among marg1(), marg2() and FDRreg() which yields the highest sample likelihood. Default is set to \emph{1}.}
}
\value{
This function returns a list consisting of the following:

\item{atoms}{The vector of means for the Gaussian distributions used to approximate \eqn{G(\cdot)}.}

\item{probs}{The vector of probabilities for each Gaussian component used to approximate \eqn{G(\cdot)}.}

\item{f1y}{The vector of estimated signal densities evaluated at the data points.}

\item{f0y}{The vector of null densities evaluated at the data points.}

\item{b}{The estimates for the coefficient vector in the logistic function.}

\item{p}{The estimated prior probabilities, i.e., \eqn{\hat\pi(\cdot)} evaluated at the data points.}

\item{ll}{The log-likelihood evaluated at the estimated optima.}

\item{rejset}{The vector of \eqn{1}s and \eqn{0}s where \eqn{1} indicates that the corresponding hypothesis is to be rejected.}

\item{den}{The vector of estimated conditional densities evaluated at the data points.}

\item{localfdr}{The vector of estimated local false discovery rates evaluated at the data points.}
}
\description{
This function estimates the signal proportion and the signal density by using
the full likelihood of the sample, followed by an EM algorithm based approach.
It returns the vector of estimated local false discovery rates and the corresponding
rejection set at a prespecified level for the false discovery rate.
}
\details{
The key observation in the full likelihood approach is that the M-step of
the EM algorithm results in two decoupled optimization problems, one involving \eqn{\pi^*(\cdot)}
and the other involving \eqn{\phi_1(\cdot)}. These two individual problems are then
solved using the BFGS algorithm and the Rmosek optimization suite, as has been discussed previously in
the \strong{Details} sections of the methods marg1() and marg2().\cr
The FDRreg() method was introduced in Scott et al (2015). We recommend using the version of
the FDRreg() package available in \url{https://github.com/jgscott/FDRreg/tree/master/R_pkg}.
}
\references{
Deb, N., Saha, S., Guntuboyina, A. and Sen, B., 2018. Two-component Mixture Model in the Presence of Covariates. arXiv preprint arXiv:1810.07897.

Scott, J.G., Kelly, R.C., Smith, M.A., Zhou, P. and Kass, R.E., 2015. False discovery rate regression: an application to neural synchrony detection in primary visual cortex. Journal of the American Statistical Association, 110(510), pp.459-471.
}
