% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MLE_sNiW_mmEM.R
\name{MLE_NiW_mmEM}
\alias{MLE_NiW_mmEM}
\title{EM MLE for mixture of NiW}
\usage{
MLE_NiW_mmEM(mu_list, S_list, hyperG0, K, maxit = 100, tol = 0.1,
  doPlot = TRUE)
}
\arguments{
\item{mu_list}{a list of length \code{N} whose elements are observed vectors of length \code{d}
of the mean parameters.}

\item{S_list}{a list of length \code{N} whose elements are observed variance-covariance matrices
of dimension \code{d x d}.}

\item{hyperG0}{prior mixing distribution used for randomly initializing the algorithm.}

\item{K}{integer giving the number of mixture components.}

\item{maxit}{integer giving the maximum number of iteration for the EM algorithm.
Default is \code{100}.}

\item{tol}{real number giving the tolerance for the stopping of the EM algorithm.
Default is \code{0.1}.}

\item{doPlot}{a logical flag indicating wether the algorithm progression should be plotted. Default is \code{TRUE}.}
}
\description{
Maximum likelihood estimation of mixture of
Normal inverse Wishart distributed observations with an EM algorithm
}
\examples{
set.seed(123)
U_mu <- list()
U_Sigma <- list()
U_nu<-list()
U_kappa<-list()

d <- 2
hyperG0 <- list()
hyperG0[["mu"]] <- rep(1,d)
hyperG0[["kappa"]] <- 0.01
hyperG0[["nu"]] <- d+1
hyperG0[["lambda"]] <- diag(d)

for(k in 1:200){

  NiW <- rNiW(hyperG0, diagVar=FALSE)
  U_mu[[k]] <-NiW[["mu"]]
  U_Sigma[[k]] <-NiW[["S"]]
}


hyperG02 <- list()
hyperG02[["mu"]] <- rep(2,d)
hyperG02[["kappa"]] <- 1
hyperG02[["nu"]] <- d+10
hyperG02[["lambda"]] <- diag(d)/10

for(k in 201:400){

  NiW <- rNiW(hyperG02, diagVar=FALSE)
  U_mu[[k]] <-NiW[["mu"]]
  U_Sigma[[k]] <-NiW[["S"]]
}


mle <- MLE_NiW_mmEM( U_mu, U_Sigma, hyperG0, K=2)

hyperG0[["mu"]]
hyperG02[["mu"]]
mle$U_mu

hyperG0[["lambda"]]
hyperG02[["lambda"]]
mle$U_lambda

hyperG0[["nu"]]
hyperG02[["nu"]]
mle$U_nu

hyperG0[["kappa"]]
hyperG02[["kappa"]]
mle$U_kappa
}

