% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NRejections.R
\name{adj_minP}
\alias{adj_minP}
\title{Adjust p-values using minP}
\usage{
adj_minP(p, p.bt)
}
\arguments{
\item{p}{Original dataset p-values (W-vector)}

\item{p.bt}{Bootstrapped p-values (a W X B matrix)}
}
\description{
Returns minP-adjusted p-values (single-step). See Westfall & Young (1993), pg. 48.
}
\examples{
# observed p-values for 3 tests
 pvals = c(0.00233103655078803, 0.470366742594242, 0.00290278216035089
)

# bootstrapped p-values for 5 resamples
p.bt = t( structure(c(0.308528665936264, 0.517319402377912, 0.686518314693482,
                  0.637306248855186, 0.106805510862352, 0.116705315041494, 0.0732076817175753,
                  0.770308936364482, 0.384405349738909, 0.0434358213611965, 0.41497067850141,
                  0.513471489744384, 0.571213377144122, 0.628054979652722, 0.490196884985226
), .Dim = c(5L, 3L)) )

# adjust the p-values
adj_minP( p = pvals, p.bt = p.bt )
}
\references{
Westfall, P. H., & Young, S. S. (1993). Resampling-based multiple testing: Examples and
methods for p-value adjustment. Taylor & Francis Group.
}
